#include "mbed.h"
#include <iostream>
#include "LM75B.h"
#include <C12832.h>


//TextLCD lcd(p14, p15, p16, p17, p18, p19);
//lcd screen
C12832 lcd(p5, p7, p6, p8, p11);

//Sensor
LM75B sensor(p28,p27);

//RGB pins
PwmOut r (p23);
PwmOut g (p24);
PwmOut b (p25);

//Method for setting the led
void setLED(float red, float green, float blue){
    r = red;
    g = green;
    b = blue;
    }

//Speaker pin
PwmOut speaker(p26);

//Potentiometer pins
AnalogIn pot1(p19);
AnalogIn pot2(p20);

//Tickers
Ticker ledSwitch;
Ticker speakerSwitch;

//Ticker methods
void speakerFlip(){
    speaker != speaker;
}

void ledFlip(){
    setLED(1.0, 1.0, 1.0);
}

//Temp of room
float currentTemp;

    
//method to convert the pwmout to Celsius  
float getTemp(float v){
    float temp = (v * 50);
    return temp;
    }
    
//Setting the reading from potentiometer 1 to the threshold    
float threshold1(){
    return getTemp(float(pot1.read()));
    }

///Setting the reading from potentiometer 2 to the threshold   
float threshold2(){
    return getTemp(float(pot2.read()));
    }
    
    
//Attempt at the faster beep as it approaches the second threshold
void beepRate(float current, float trehs2){
    float multiplier;
    }
    
//Flashes orange at the rate specified
void orangeFlash(){
    for(int i = 0; i < 2; i++){
        setLED(0, .64, 1);
        speaker.period(1.0/5000);
        speaker = 0.5;
        wait(.25);
        setLED(1, 1, 1);
        speaker = 1;
        wait(.25);
    }
}

//Method to display the LCD
void display(){
        lcd.cls();
        lcd.locate(0, 3);
        currentTemp = sensor.temp();
        lcd.printf("CurrentTemp = %.3f\n" , currentTemp);
        lcd.printf("Threshold 1: %.3f\n", getTemp(float(pot1.read())));
        lcd.printf("Threshold 2: %.3f\n", getTemp(float(pot2.read())));
    }

int main() {
    //Ticker attaches
    //ledSwitch.attach(ledFlip, 2);
    //speakerSwitch.attach(speakerFlip, 1);
    
    while(1){
        display();
        //Green state if statement
        if(currentTemp < threshold1()){
            setLED(1, 0, 1);
            wait(1);
        }
        
        //Orange state if statement
        if(currentTemp > threshold1() && currentTemp < threshold2()){
            display();
            orangeFlash();
        }
        
        //Red state if statement
        if(currentTemp >  threshold2()){
            display();
            setLED(0, 1, 1);
            speaker.period(1.0/2000);
            speaker = 0.5;
            wait(1);
            setLED(1, 1, 1);
            speaker = 1;
            wait(1);
        }
    }
}
