#ifndef TILTMETER_H
#define TILTMETER_H

class Tiltmeter
{
public:

   // Default constructor
   Tiltmeter();


   // Detect the presence of tiltmeter sensor and ensure its status is appropriately set.
   //
   // Arguments:
   //    None
   //
   // Returns:
   //    The function returns true if the sensor is present and ready to use, and false otherwise.
   virtual bool TestConnection() = 0;


   // Compute the tilt angles and store them internally; you can access the computed values by
   // calling the GetRoll() and GetPitch() functions.
   //
   // Arguments:
   //    None
   //
   // Returns:
   //    Nothing
   void ComputeTiltAngles();


   // Get the most recent roll angle as computed by calling ComputeTilt()
   //
   // Arguments:
   //    None
   //
   // Returns:
   //    The function returns the roll angle in units of degrees
   float GetRoll() const;


   // Get the most recent roll angle as computed by calling ComputeTilt()
   //
   // Arguments:
   //    None
   //
   // Returns:
   //    The function returns the roll angle in units of degrees
   float GetPitch() const;


private:

   // Read the accelerometer data and store the values for later use. You can access the values by
   // calling the GetAccelX(), GetAccelY() and/or GetAccelZ();
   //
   // Arguments:
   //    None
   //
   // Returns:
   //    Nothing
   //
   // Remarks:
   //    The data will be stored in the 'MeasuredAccel' member variable in units of m/s/s
   virtual void ReadAccelerometers() = 0;


   // Get the most recently measured X-axis acceleration as stored during the last call to
   // ReadAccelerometer()
   //
   // Arguments:
   //    None
   //
   // Returns:
   //    The function returns the most recently measured X-axis acceleration in units of m/s/s
   virtual float GetAccelX() const = 0;


   // Get the most recently measured Y-axis acceleration as stored during the last call to
   // ReadAccelerometer()
   //
   // Arguments:
   //    None
   //
   // Returns:
   //    The function returns the most recently measured Y-axis acceleration in units of m/s/s
   virtual float GetAccelY() const = 0;


   // Get the most recently measured Z-axis acceleration as stored during the last call to
   // ReadAccelerometer()
   //
   // Arguments:
   //    None
   //
   // Returns:
   //    The function returns the most recently measured Z-axis acceleration in units of m/s/s
   virtual float GetAccelZ() const = 0;


private:

   // Variables to store the roll and pitch values in units of degrees
   float RollAngle, PitchAngle;


};

#endif


