#include "mbed.h"

DigitalOut myled(LED1);
Serial pc(USBTX, USBRX); // tx, rx
AnalogIn ain(A0); //is ADC0_0: must be channel 0 of ADC0 or ADC1

#define ADCn_INSEL_TEMPERATURE (0x3)
#define SYSCON_PDRUNCFG_TS_PD (1 << 18)
#define SYSCON_PDRUNCFG_IREF_PD (1 << 17)

int main() {
    pc.printf("Starting program...\r\n");
    
    //Enable temperature sensor and internal voltage reference, see um chapter 31
    LPC_SYSCON->PDRUNCFG &= ~(SYSCON_PDRUNCFG_TS_PD | SYSCON_PDRUNCFG_IREF_PD);
    
    //Select source for channel 0: temperature sensor
    LPC_ADC0->INSEL = ADCn_INSEL_TEMPERATURE;
    
    while(1) {
        unsigned short raw = ain.read_u16();
        pc.printf("Raw u16 value %u\r\n", raw);
        pc.printf("Raw 12 Bit value %u\r\n", (raw >> 4));
        float value = ((float)raw) / (float) 0xffff;
        pc.printf("Float value %f\r\n", value);
        pc.printf("Read value %f mV\r\n", value * 3300.0f);
        float temperature = -(((value * 3300.0f) - 577.3f) / 2.29f); 
        pc.printf("Read temperature (about) %f deg C\r\n", temperature);
        myled = !myled;
        wait(1);
    }
}
