#include "display.h"

Display::SPI2::SPI2(PinName mosi, PinName miso, PinName clk)
: SPI(mosi, miso, clk)
{
    format(8,3);
    frequency(2000000);
};


Display::Display()
: m_spi(p5, NC, p7)
, m_oled(m_spi, p18, p19, p20)
{
}

    
void Display::clear()
{
    m_oled.clearDisplay();
}
    
void Display::display()
{
    m_oled.display();
}

void Display::sendTo(const char* text)
{
    uint8_t line = 0;
    if (strstr(text, "RPM"))
    {
        line = 1;
    }
    else if (strstr(text, "Oil"))
    {
        line = 2;
    }
    else if (strstr(text, "Coolant"))
    {
        line = 3;
    }
    else if (strstr(text, "Speed")) 
    {
        return;
    }
    
    m_oled.setCursor(0, line * 8);
    m_oled.printf("%s", text);

}