#include "Throttle.h"

const char Throttle::REQUEST_DATA[8] = {0x02, 0x01, 0x11, 0, 0, 0, 0, 0};

Throttle::Throttle()
: PidValue("Throttle", "%")
{
}

bool Throttle::decode(const uint8_t* data, uint16_t length)
{
    if (length < 2)
    {
        return false;
    }
    
    if ((data[1] != 0x11) || length != 3)
    {
        return false;
    }
    
    m_value = data[2] * 100 /  255; // %
    return true;
}
