#include "EngineRpm.h"

const char EngineRpm::REQUEST_DATA[8] = {0x02, 0x01, 0x0C, 0, 0, 0, 0, 0};

EngineRpm::EngineRpm()
: PidValue("Engine RPM", "rpm")
{
}

bool EngineRpm::decode(const uint8_t* data, uint16_t length)
{
    if (length < 2)
    {
        return false;
    }
    
    if ((data[1] != 0x0C) || length != 4)
    {
        return false;
    }
    
    m_value = ((data[2] << 8) | data[3]) >> 2; //rpm
    return true;
}
