#include "EngineCoolantTemperature.h"

const char EngineCoolantTemp::REQUEST_DATA[8] = {0x02, 0x01, 0x05, 0, 0, 0, 0, 0};

EngineCoolantTemp::EngineCoolantTemp()
: PidValue("Coolant Temp", "C")
{
}

bool EngineCoolantTemp::decode(const uint8_t* data, uint16_t length)
{
    if (length < 2)
    {
        return false;
    }
    
    if ((data[1] != 0x05) || length != 3)
    {
        return false;
    }
    
    m_value = data[2] - 40; // degree celcius
    return true;
}
