#ifndef PIDVALUE_H
#define PIDVALUE_H

#include <stdint.h>

class PidValue
{
public:
    PidValue(const char* name, const char* unit);
    virtual bool decode(const uint8_t* data, uint16_t length) = 0;
    void print();
    const char* getName();
    const char* getUnit();
    unsigned int getValue();
protected:    
    unsigned int m_value;
    const char* m_unit;
    const char* m_name;
};

#endif //PIDVALUE_H