#ifndef DISPLAY_H
#define DISPLAY_H

#include "mbed.h"

#include "Adafruit_SSD1306.h"

class Display
{
public:
    
    Display();
    
    void clear();
    
    void display();
    
    void sendTo(const char* text);
    
private:
    // an SPI sub-class that provides a constructed default format and frequency
    class SPI2 : public SPI
    {
    public:
        SPI2(PinName mosi, PinName miso, PinName clk);
    };
    
    SPI2 m_spi;
    Adafruit_SSD1306 m_oled;
};
#endif //DISPLAY_H