#include "VehicleSpeed.h"

const char VehicleSpeed::REQUEST_DATA[8] = {0x02, 0x01, 0x0D, 0, 0, 0, 0, 0};

VehicleSpeed::VehicleSpeed()
: PidValue("Speed", "km/h")
{
}

bool VehicleSpeed::decode(const uint8_t* data, uint16_t length)
{
    if (length < 2)
    {
        return false;
    }
    
    if ((data[1] != 0x0D) || length != 3)
    {
        return false;
    }
    
    m_value = data[2]; // km/h
    return true;
}
