#include "PidValue.h"
#include "DebugPrint.h"

PidValue::PidValue(const char* name, const char* unit)
: m_value(0)
, m_unit(unit)
, m_name(name)
{
}

void PidValue::print()
{
    pc.printf("%d %s\r\n", m_value, m_unit);
}

const char* PidValue::getName()
{
    return m_name;
}

const char* PidValue::getUnit()
{
    return m_unit;
}
unsigned int PidValue::getValue()
{
    return m_value;
}