#include "PidDecoder.h"
#include "EngineCoolantTemperature.h"
#include "EngineRpm.h"
#include "VehicleSpeed.h"
#include "Throttle.h"
#include "OilTemperature.h"

#include "DebugPrint.h"
#include "display.h"

static VehicleSpeed speed;
static EngineRpm rpm;
static EngineCoolantTemp temp;
static Throttle throttle;
OilTemperature oilTemperature;
static PidValue* pids[] =
{ &speed, &rpm, &temp, &throttle, &oilTemperature
};

extern Display display;
char buf[128];                          
                             
void PidDecoder::decode(const uint8_t* data, uint16_t length)
{   
    for (unsigned int i = 0; i < sizeof(pids) / sizeof(pids[0]); i++)
    {
        if (pids[i]->decode(data, length))
        {
            pc.printf("New Value for %s: ", pids[i]->getName());
            pids[i]->print();
            snprintf(buf, sizeof(buf), "%s: %d %s", pids[i]->getName(), pids[i]->getValue(), pids[i]->getUnit());
            display.sendTo(buf);
            display.display();
        }
    }
}
