#include "OilTemperature.h"

const char OilTemperature::REQUEST_DATA[8] = {0x02, 0x21, 0x01, 0, 0, 0, 0, 0};
const char OilTemperature::SECOND_MESSAGE[8] = {0x30, 0, 0, 0, 0, 0, 0, 0};

OilTemperature::OilTemperature()
: PidValue("Oil Temp", "C")
{
}

bool OilTemperature::decode(const uint8_t* data, uint16_t length)
{
    if (length < 2)
    {
        return false;
    }
    
    if ((length != 31) || (data[0] != 0x61) || (data[1] != 0x01))
    {
        return false;
    }
    
    m_value = data[30] - 40; // deg C
    return true;
}
