#include "mbed.h"
#include "MMA8451Q.h"
#include "USBKeyboard.h"
#include "USBHID.h"
#include "raiden_const.h"
#include "PololuLedStrip.h"

// you can't try to use USBKeyboard if it doesn't exist otherwise it will hang
#define DEBUG 0

#define MMA8451_I2C_ADDRESS (0x1d<<1)
#define THRESHOLD 0.2

#define LED_COUNT 24
#define DATA_PIN D6
PololuLedStrip LEDStrip(D8);

uint8_t r = 255;
uint8_t g = 255;
uint8_t b = 255;

void flash() {
    rgb_color white = (rgb_color){254,254,254};
    rgb_color all_white[LED_COUNT];
    for (int i = 0; i < LED_COUNT; i++) {
        all_white[i] = white;
    }
    LEDStrip.write(all_white, LED_COUNT);
}
void flashOff() {
    rgb_color black = (rgb_color){0,0,0};
    rgb_color all_black[LED_COUNT];
    for (int i = 0; i < LED_COUNT; i++) {
        all_black[i] = black;
    }
    LEDStrip.write(all_black, LED_COUNT);
}

int main(void) {
    Serial mac(USBTX, USBRX);
    
    MMA8451Q acc(PTE25, PTE24, MMA8451_I2C_ADDRESS);
    PwmOut rled(LED_RED);
    PwmOut bled(LED_BLUE);

    AnalogIn flex(A0);
    
    #if DEBUG == 0
        USBKeyboard keyboard;
        HID_REPORT report;
 
    report.data[0] = 1; // this is the USB ID
    report.data[1] = 0; // this is a modifier key (ie: ctrl/shift/alt)
    report.data[2] = 0; // i haven't figured this one out
    report.data[3] = 0; // UP
    report.data[4] = 0; // DOWN
    report.data[5] = 0; // LEFT
    report.data[6] = 0; // RIGHT
    report.data[7] = 0; // SHOOT
    report.data[8] = 0; // BOMB
    report.length = 9;
    #endif

    mac.printf("R A I D E N   X", flex.read());
    flash();
    wait(2);
    flashOff();
    while (true) {
        mac.printf("%f", flex.read());

        float x = acc.getAccX();
        float y = acc.getAccY();

        if (x < 0 - THRESHOLD) {
            mac.printf("Down\r\n");
            #if DEBUG == 0
                report.data[6] = 0;
                report.data[5] = keymap[DOWN_ARROW].usage;
            #endif
        } else if (x > 0 + THRESHOLD) {
            mac.printf("Up\r\n");
            #if DEBUG == 0
                report.data[6] = keymap[UP_ARROW].usage;
                report.data[5] = 0;
            #endif
        } else {
            #if DEBUG == 0
                report.data[5] = 0;
                report.data[6] = 0;
            #endif
        }

        if (y < 0 - THRESHOLD) {
            mac.printf("Left\r\n");
            #if DEBUG == 0
                report.data[3] = keymap[LEFT_ARROW].usage;
                report.data[4] = 0;
            #endif
        } else if (y > 0 + THRESHOLD) {
            mac.printf("Right\r\n");
            #if DEBUG == 0
                report.data[3] = 0;
                report.data[4] = keymap[RIGHT_ARROW].usage;
            #endif
        } else {
            #if DEBUG == 0
                report.data[3] = 0;
                report.data[4] = 0;
            #endif
        }
        
        if (flex.read() < 0.3) {
            mac.printf("Bomb");
            flash();
            #if DEBUG == 0
                report.data[8] = keymap['x'].usage;
            #endif
        } else {
            flashOff();
            #if DEBUG == 0
                report.data[8] = 0;
            #endif
        }

        rled = 1.0 - abs(acc.getAccX());
        bled = 1.0 - abs(acc.getAccY());
        
        #if DEBUG == 0
            report.data[7] = keymap['z'].usage;
            keyboard.send(&report);
        #elif DEBUG == 1
            wait(0.5);
        #endif
    }
}
