#include "mbed.h"
#include "USBKeyboard.h"

USBKeyboard keyboard;

//Bus of buttons
BusInOut buttons(D2, D3, D4, D5, D6, D7, D8, D9, D10, D11);
BusOut myleds(LED1, LED2, LED3, LED4);
DigitalIn b1(D2),b2(D3),b3(D4),b4(D5),b5(D6),b6(D7),b7(D8),b8(D9),b9(D10),b10(D11);

int main() {
    buttons.input();
    buttons.mode(PullDown);
    uint16_t p_bus = 0;
    myleds = 4;
    while (1) {
        //if the bus of buttons has changed, send a report

        if (~buttons.read() != p_bus) {
            p_bus = ~buttons.read();
            if((b5 == 0))        //Left thumb pressed
            {
              myleds = 1;
              while (1){
                
                p_bus = ~buttons.read();
                if (~buttons.read() != p_bus){break;}
              }
              myleds = 2;
              if ((b5==0) && (b1==0))
              {
                keyboard.keyCode('w');
                while ((b5==0) && (b1==0)){}
              }
              if ((b5==0) && (b2==0))
              {
                keyboard.keyCode('e');
                while ((b5==0) && (b2==0)){}
              }
              if ((b5==0) && (b3==0))
              {
                keyboard.keyCode('r');
                while ((b5==0) && (b3==0)){}
              }
              if ((b5==0) && (b4==0))
              {
                int count = 0;
                while((b5==0)&&(b4==0)&&(count == 0))
                {
                    if((b5==0)&&(b4==0)&&(b3==0))
                    {keyboard.keyCode('g');
                    while ((b5==0)&&(b4==0)&&(b3==0)){}
                    count++;}
                }
                wait(0.1);
                if ((count == 0))
                {
                    keyboard.keyCode('t');
                }
              }
              if ((b5==0) && (b7==0))
              {
                keyboard.keyCode('y');
                while ((b5==0) && (b7==0)){}
              }
              if ((b5==0) && (b8==0))
              {
                keyboard.keyCode('u');
                while ((b5==0) && (b8==0)){}
              }
              if ((b5==0) && (b9==0))
              {
                keyboard.keyCode('i');
                while ((b5==0) && (b9==0)){}
              }
              if ((b5==0) && (b10==0))
              {
                keyboard.keyCode('o');
                while ((b5==0) && (b10==0)){}
              }
              if ((b5==0) && (b6==0))
              {
                keyboard.keyCode(' ');
                while ((b5==0) && (b6==0)){}
              }

            }
            else if (b6 == 0)    //Right thumb pressed
            {

              myleds = 1;
              while (1){
                if (b6 == 1){
                  keyboard.keyCode('h');
                  break;
                }
                p_bus = ~buttons.read();
                if (~buttons.read() != p_bus){break;}
              }
              myleds = 2;
              if ((b6==0) && (b1==0))
              {
                keyboard.keyCode('z');
                while ((b6==0) && (b1==0)){}
              }
              if ((b6==0) && (b2==0))
              {
                keyboard.keyCode('x');
                while ((b6==0) && (b2==0)){}
              }
              if ((b6==0) && (b3==0))
              {
                keyboard.keyCode('c');
                while ((b6==0) && (b3==0)){}
              }
              if ((b6==0) && (b4==0))
              {
                keyboard.keyCode('v');
                while ((b6==0) && (b4==0)){}
              }
              if ((b6==0) && (b7==0))
              {
                int count2 = 0;
                while((b6==0)&&(b7==0)&&(count2 == 0))
                {
                    if((b6==0)&&(b7==0)&&(b8==0))
                    {keyboard.keyCode('h');
                    while ((b6==0)&&(b7==0)&&(b8==0)){}
                    count2++;}
                }
                wait(0.1);
                if ((count2 == 0))
                {
                    keyboard.keyCode('b');
                }
              }
              if ((b6==0) && (b8==0))
              {
                keyboard.keyCode('n');
                while ((b6==0) && (b8==0)){}
              }
              if ((b6==0) && (b9==0))
              {
                keyboard.keyCode('m');
                while ((b6==0) && (b9==0)){}
              }
              if ((b6==0) && (b10==0))
              {
                keyboard.keyCode('q');
                while ((b6==0) && (b10==0)){}
              }
              if ((b6==0) && (b5==0))
              {
                keyboard.keyCode(' ');
                while ((b5==0) && (b6==0)){}
              }

            }
            else if ((b5==0) && (b6==0)) //both thumb pressed
            {
              keyboard.keyCode(' ');
            }
            else                      //No thumb pressed
            {
              if(p_bus & 0x01)
              {
                keyboard.keyCode('a');
                while (p_bus & 0x01){p_bus = ~buttons.read();}
              }
              if(p_bus & 0x02)
              {
                keyboard.keyCode('s');
                while (p_bus & 0x02){p_bus = ~buttons.read();}
              }
              if(p_bus & 0x04)
              {
                keyboard.keyCode('d');
                while (p_bus & 0x04){p_bus = ~buttons.read();}
              }
              if(p_bus & 0x08)
              {
                keyboard.keyCode('f');
                while (p_bus & 0x08){p_bus = ~buttons.read();}
              }
              if(p_bus & 0x40)
              {
                keyboard.keyCode('j');
                while (p_bus & 0x40){p_bus = ~buttons.read();}
              }
              if(p_bus & 0x80)
              {
                keyboard.keyCode('k');
                while (p_bus & 0x80){p_bus = ~buttons.read();}
              }
              if(p_bus & 0x160)
              {
                keyboard.keyCode('l');
                while (p_bus & 0x160){p_bus = ~buttons.read();}
              }
              if(p_bus & 0x320)
              {
                keyboard.keyCode('p');
                while (p_bus & 0x320){p_bus = ~buttons.read();}
              }

            }
        wait(0.01);
        }
    }
}