/* mbed VLSI VS1053b library
 * Copyright (c) 2010 Christian Schmiljun
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
 
#ifdef VS1053B_PCM_RECORDER_0_9

/*

    VS1053 WAV PCM Recorder Application

    * Allows the VS1053 to record from microphone or line inputs into WAV PCM Vorbis format.
    * Optimized for best possible audio quality:
          o Dynamic range 95 dB
          o Interchannel isolation 95 dB
          o Frequency response 0.8 dB 20-20000 Hz, 0.1 dB 70-20000 Hz
    * 48 kHz stereo, 1.536 Mbit/s.

Version: 0.90
Modified: 2010-06-28
Devices: VS1053B
Download: vs1053-pcm-recorder-090.zip 

*/

const unsigned short vs1053b_patch[1510] ={
  0x0007, 0x0001, 0xc01a, 0x0006, 0x0001, 0x0002, 0x0007, 0x0001, /*    0 */
  0x0008, 0x0006, 0x8002, 0x0000, 0x0007, 0x0001, 0x000c, 0x0006, /*    8 */
  0x0002, 0x7000, 0x0017, 0x0007, 0x0001, 0x8034, 0x0006, 0x001c, /*   10 */
  0x0000, 0x0fd0, 0xf400, 0x5404, 0x0000, 0x0851, 0xf400, 0x5648, /*   18 */
  0xf400, 0x5404, 0xf400, 0x5658, 0xf400, 0x5404, 0xf400, 0x5640, /*   20 */
  0x0000, 0x800a, 0x2900, 0x9000, 0x0006, 0x2016, 0x2a00, 0x1b0e, /*   28 */
  0x2a00, 0x108e, 0x2a00, 0x15ce, 0x0007, 0x0001, 0x1800, 0x0006, /*   30 */
  0x8006, 0x0000, 0x0007, 0x0001, 0x8042, 0x0006, 0x002a, 0x3e12, /*   38 */
  0xb817, 0x3e12, 0x7808, 0x3e18, 0x3821, 0x3e18, 0xb823, 0x3e15, /*   40 */
  0x4024, 0x3e10, 0x7800, 0x48b2, 0x0024, 0x0000, 0x800a, 0x2900, /*   48 */
  0x3d00, 0x3e10, 0x7800, 0x36f0, 0x5800, 0x2210, 0x0000, 0x36f0, /*   50 */
  0x5800, 0x36f5, 0x4024, 0x36f8, 0x9823, 0x36f8, 0x1821, 0x36f2, /*   58 */
  0x5808, 0x3602, 0x8024, 0x0030, 0x0717, 0x2100, 0x0000, 0x3f05, /*   60 */
  0xdbd7, 0x0007, 0x0001, 0x8057, 0x0006, 0x002a, 0x3e12, 0xb817, /*   68 */
  0x3e12, 0x7808, 0x3e18, 0x3821, 0x3e18, 0xb823, 0x3e15, 0x4024, /*   70 */
  0x3e10, 0x7800, 0x48b2, 0x0024, 0x0000, 0x800a, 0x2900, 0x5d80, /*   78 */
  0x3e10, 0x7800, 0x36f0, 0x5800, 0x2210, 0x0000, 0x36f0, 0x5800, /*   80 */
  0x36f5, 0x4024, 0x36f8, 0x9823, 0x36f8, 0x1821, 0x36f2, 0x5808, /*   88 */
  0x3602, 0x8024, 0x0030, 0x0717, 0x2100, 0x0000, 0x3f05, 0xdbd7, /*   90 */
  0x0007, 0x0001, 0x806c, 0x0006, 0x002a, 0x3e12, 0xb817, 0x3e12, /*   98 */
  0x7808, 0x3e18, 0x3821, 0x3e18, 0xb823, 0x3e15, 0x4024, 0x3e10, /*   a0 */
  0x7800, 0x48b2, 0x0024, 0x0000, 0x800a, 0x2900, 0x7180, 0x3e10, /*   a8 */
  0x7800, 0x36f0, 0x5800, 0x2210, 0x0000, 0x36f0, 0x5800, 0x36f5, /*   b0 */
  0x4024, 0x36f8, 0x9823, 0x36f8, 0x1821, 0x36f2, 0x5808, 0x3602, /*   b8 */
  0x8024, 0x0030, 0x0717, 0x2100, 0x0000, 0x3f05, 0xdbd7, 0x0007, /*   c0 */
  0x0001, 0x8010, 0x0006, 0x000e, 0x3e02, 0x8024, 0x0001, 0x000a, /*   c8 */
  0x6012, 0x0024, 0xfea2, 0x0024, 0x48b2, 0x1bca, 0x2000, 0x0000, /*   d0 */
  0x4180, 0x0024, 0x0007, 0x0001, 0x8081, 0x0006, 0x00e6, 0x3e00, /*   d8 */
  0x7843, 0x3e01, 0x3845, 0x3e04, 0x3812, 0x0006, 0x08d0, 0x3000, /*   e0 */
  0x4024, 0x6182, 0x0024, 0x0030, 0x06d0, 0x2800, 0x24d5, 0xb882, /*   e8 */
  0x0024, 0x0030, 0x0210, 0x0000, 0x0005, 0x0000, 0x0201, 0xa016, /*   f0 */
  0x4004, 0x1fff, 0xfe01, 0xae1a, 0x0024, 0xc342, 0x0024, 0xb882, /*   f8 */
  0x2001, 0x0030, 0x06d0, 0x3800, 0x4024, 0x0006, 0x0890, 0x3004, /*  100 */
  0x0024, 0x3000, 0x4024, 0x0006, 0x12d0, 0x6182, 0x0024, 0x3000, /*  108 */
  0x4024, 0x2800, 0x3c85, 0xf400, 0x4050, 0x3009, 0x2000, 0x0006, /*  110 */
  0x0892, 0x0006, 0x08d0, 0x3000, 0x4024, 0x6192, 0x0024, 0x3800, /*  118 */
  0x4024, 0x0030, 0x0250, 0xb882, 0x2001, 0x0030, 0x0710, 0x3800, /*  120 */
  0x4024, 0x0006, 0x12d0, 0x3000, 0x4024, 0x6192, 0x0024, 0x3800, /*  128 */
  0x4024, 0x3204, 0x0024, 0x3023, 0x0024, 0x30e0, 0xc024, 0x6312, /*  130 */
  0x0024, 0x0000, 0x00c3, 0x2800, 0x2fc1, 0x0000, 0x0024, 0x3033, /*  138 */
  0x0024, 0x3a04, 0x0024, 0x3000, 0x4024, 0x6182, 0x0024, 0x0006, /*  140 */
  0x0890, 0x2800, 0x2e58, 0x0006, 0x0301, 0x3a00, 0x4024, 0x0000, /*  148 */
  0x00c3, 0x3004, 0x0024, 0x3013, 0x0024, 0x3000, 0x4024, 0x0006, /*  150 */
  0x12d0, 0x3800, 0x4024, 0x0030, 0x0310, 0xf000, 0x0001, 0x6236, /*  158 */
  0x0024, 0x001f, 0xffc3, 0x2800, 0x3215, 0x0000, 0x0024, 0x0000, /*  160 */
  0x0203, 0xa132, 0x0024, 0x001f, 0xffc3, 0xb136, 0x0024, 0x6306, /*  168 */
  0x0024, 0x0000, 0x0024, 0x2800, 0x3491, 0x0000, 0x0024, 0x0020, /*  170 */
  0x0003, 0xb132, 0x0024, 0x0000, 0x0024, 0x2800, 0x3905, 0x0000, /*  178 */
  0x0024, 0x0000, 0x0081, 0xb212, 0x0024, 0x0000, 0x0024, 0x2800, /*  180 */
  0x3885, 0x0000, 0x0024, 0x6892, 0x0024, 0xb212, 0x0024, 0x0000, /*  188 */
  0x0005, 0x2800, 0x3ad5, 0x0030, 0x0310, 0x0000, 0x3fc1, 0x3000, /*  190 */
  0x8024, 0xb214, 0x0024, 0x003f, 0xc001, 0xb010, 0x0024, 0xc200, /*  198 */
  0x0024, 0x0030, 0x0310, 0x3800, 0x0024, 0x36f4, 0x1812, 0x36f1, /*  1a0 */
  0x1805, 0x36f0, 0x5803, 0x2000, 0x0000, 0x0000, 0x0024, 0x0000, /*  1a8 */
  0x0005, 0x0030, 0x0310, 0x003f, 0xc001, 0x4088, 0x0002, 0xb214, /*  1b0 */
  0x0024, 0x1fff, 0xfe01, 0xae12, 0x0024, 0x2800, 0x3880, 0xc200, /*  1b8 */
  0x0024, 0x2800, 0x2740, 0x3800, 0x0024, 0x0007, 0x0001, 0x80f4, /*  1c0 */
  0x0006, 0x0104, 0x3e12, 0x0024, 0x3e05, 0xb814, 0x3615, 0x0024, /*  1c8 */
  0x3e00, 0x3841, 0x3e00, 0xb843, 0x3e01, 0x3845, 0x3e04, 0x3851, /*  1d0 */
  0x0030, 0x10d0, 0x3e04, 0x8024, 0x3010, 0x0024, 0x3000, 0xc024, /*  1d8 */
  0x0006, 0x1190, 0x3000, 0x4024, 0x6182, 0x0024, 0x0000, 0x0024, /*  1e0 */
  0x2800, 0x5d15, 0x0000, 0x0024, 0x0000, 0x00c1, 0x0030, 0x03d0, /*  1e8 */
  0x6898, 0x0002, 0xb214, 0x0024, 0x6244, 0x0024, 0x0000, 0x0802, /*  1f0 */
  0x2800, 0x5945, 0x0000, 0x0024, 0x0020, 0x0002, 0x0006, 0x1150, /*  1f8 */
  0x3000, 0x4024, 0x6124, 0x0024, 0x0000, 0x0024, 0x2800, 0x45c1, /*  200 */
  0x0000, 0x0024, 0x0000, 0x0802, 0x4122, 0x0024, 0x3800, 0x4024, /*  208 */
  0x0006, 0xf011, 0x0006, 0x0190, 0x2900, 0xae80, 0x3613, 0x0024, /*  210 */
  0x0006, 0x0250, 0x0006, 0x1152, 0x0006, 0xf011, 0x4082, 0x0800, /*  218 */
  0xfe82, 0x184c, 0x1fff, 0xfc41, 0x48ba, 0x0024, 0xae1a, 0x0024, /*  220 */
  0x2900, 0xae80, 0x4380, 0x4102, 0x0006, 0x1110, 0x4086, 0x0800, /*  228 */
  0xfe86, 0x0024, 0x48ba, 0x0024, 0xae12, 0x0024, 0x4086, 0x0001, /*  230 */
  0x0000, 0x0180, 0x6100, 0x0024, 0x0000, 0x0080, 0x2800, 0x50c1, /*  238 */
  0x4100, 0x0024, 0x0006, 0x1081, 0x3800, 0x0024, 0x0006, 0x1090, /*  240 */
  0x3004, 0x8024, 0xf400, 0x4491, 0x3113, 0x0024, 0x3804, 0x4024, /*  248 */
  0x3a00, 0x8024, 0x3004, 0x8024, 0xf400, 0x4491, 0x3113, 0x0024, /*  250 */
  0x3804, 0x4024, 0x3a00, 0xc024, 0x3000, 0x0024, 0x6012, 0x0024, /*  258 */
  0x0006, 0x0f00, 0x2800, 0x50c8, 0x0000, 0x0024, 0x3800, 0x0024, /*  260 */
  0x0000, 0x0080, 0x0030, 0x0010, 0xb888, 0x0001, 0x0030, 0x0710, /*  268 */
  0xb102, 0x2004, 0x0006, 0x08d0, 0x3001, 0x4024, 0x0006, 0x0910, /*  270 */
  0x3001, 0x0024, 0x6400, 0x0024, 0x6050, 0x0024, 0x0030, 0x06d0, /*  278 */
  0x2800, 0x5651, 0xb880, 0x0024, 0x4280, 0x184c, 0x2900, 0x2040, /*  280 */
  0x4184, 0x0024, 0x6890, 0x184c, 0xc104, 0x0024, 0x2900, 0x2040, /*  288 */
  0x4380, 0x0024, 0xb880, 0x0024, 0x3800, 0x0024, 0x36f4, 0x8024, /*  290 */
  0x36f4, 0x1811, 0x36f1, 0x1805, 0x36f0, 0x9803, 0x36f0, 0x1801, /*  298 */
  0x3405, 0x9014, 0x36f3, 0x0024, 0x36f2, 0x0024, 0x2000, 0x0000, /*  2a0 */
  0x0000, 0x0024, 0x0000, 0x0802, 0x0006, 0x1152, 0x3201, 0x0024, /*  2a8 */
  0x6424, 0x0024, 0x6284, 0x2802, 0x0000, 0x0024, 0x2800, 0x45d5, /*  2b0 */
  0x0000, 0x0024, 0x3800, 0x4024, 0x0000, 0x0081, 0x0030, 0x0690, /*  2b8 */
  0xb882, 0x22c1, 0x3800, 0x4024, 0x0030, 0x0590, 0x2800, 0x45c0, /*  2c0 */
  0x3800, 0x4024, 0x2800, 0x5640, 0x4190, 0x0024, 0x0007, 0x0001, /*  2c8 */
  0x8176, 0x0006, 0x00a0, 0x3e12, 0x0024, 0x3e05, 0xb814, 0x3625, /*  2d0 */
  0x0024, 0x3e00, 0x3841, 0x3e00, 0xb843, 0x3e04, 0x3851, 0x0006, /*  2d8 */
  0x1110, 0x3e04, 0xb813, 0x3000, 0x0024, 0x6080, 0x0024, 0x0006, /*  2e0 */
  0x11d2, 0x2800, 0x6f45, 0x0000, 0x0081, 0x6010, 0x984c, 0x3800, /*  2e8 */
  0x0024, 0x0006, 0x10d0, 0x3200, 0x0024, 0xf100, 0x0011, 0xf100, /*  2f0 */
  0x0024, 0xf102, 0x0400, 0x0006, 0x1311, 0x2900, 0x0400, 0x3100, /*  2f8 */
  0x8024, 0x0030, 0x1293, 0x3413, 0x184c, 0x3c04, 0x4024, 0x3b00, /*  300 */
  0x0024, 0x3004, 0xc024, 0xf400, 0x44d1, 0x3113, 0x0024, 0x3804, /*  308 */
  0x4024, 0x3310, 0x0024, 0x3a00, 0x0024, 0x0006, 0x1212, 0x3200, /*  310 */
  0x0024, 0xf100, 0x13d1, 0xf100, 0x0402, 0x2900, 0x0400, 0xf102, /*  318 */
  0x0c00, 0x0006, 0x1081, 0x0030, 0x12d1, 0x3900, 0x0024, 0x3004, /*  320 */
  0xc024, 0xf400, 0x44d1, 0x3113, 0x0024, 0x3804, 0x4024, 0x3300, /*  328 */
  0x0024, 0x3a00, 0x0024, 0xf400, 0x4440, 0x6010, 0x0024, 0x0006, /*  330 */
  0x0f00, 0x2800, 0x6b08, 0x0000, 0x0024, 0x3800, 0x0024, 0x0006, /*  338 */
  0x0950, 0xb386, 0x0000, 0x6094, 0x0024, 0x1fee, 0xe000, 0xb882, /*  340 */
  0x2002, 0xf400, 0x4041, 0x6dc2, 0x0024, 0x0000, 0x0000, 0x2800, /*  348 */
  0x6f48, 0x0000, 0x0024, 0x3800, 0x0024, 0x0000, 0x0210, 0x3010, /*  350 */
  0x0024, 0x30f0, 0x4024, 0x6c92, 0x0024, 0x3810, 0x0024, 0x38f0, /*  358 */
  0x4024, 0x36f4, 0x9813, 0x36f4, 0x1811, 0x36f0, 0x9803, 0x36f0, /*  360 */
  0x1801, 0x3405, 0x9014, 0x36f3, 0x0024, 0x36f2, 0x0024, 0x2000, /*  368 */
  0x0000, 0x0000, 0x0024, 0x0007, 0x0001, 0x81c6, 0x0006, 0x00f4, /*  370 */
  0x3e00, 0x3841, 0x0000, 0x0201, 0x3e00, 0xb843, 0x3e01, 0x3845, /*  378 */
  0x3e04, 0x3812, 0x0030, 0x0410, 0x3000, 0x0024, 0x6012, 0x0024, /*  380 */
  0x0006, 0x08d0, 0x2800, 0x7ec5, 0x0000, 0x0181, 0x6012, 0x0024, /*  388 */
  0x0006, 0x1250, 0x2800, 0x7cc5, 0x0000, 0x05c1, 0x6012, 0x0024, /*  390 */
  0x0030, 0x01d0, 0x2800, 0x7ac5, 0x0000, 0x0581, 0x6010, 0x03cc, /*  398 */
  0x0000, 0x0024, 0x2800, 0x7915, 0x0000, 0x0024, 0x3000, 0x8024, /*  3a0 */
  0x0006, 0x1250, 0x3000, 0x0024, 0x6092, 0x0024, 0x3800, 0x4024, /*  3a8 */
  0xf400, 0x4010, 0x3800, 0x8024, 0x36f4, 0x1812, 0x36f1, 0x1805, /*  3b0 */
  0x36f0, 0x9803, 0x36f0, 0x1801, 0x2000, 0x0000, 0x0000, 0x0024, /*  3b8 */
  0x0030, 0x01d0, 0x3000, 0x0024, 0x0006, 0x1250, 0x3800, 0x0024, /*  3c0 */
  0xf400, 0x4010, 0x3000, 0x0024, 0x0030, 0x0190, 0x2800, 0x7900, /*  3c8 */
  0x3800, 0x0024, 0x3000, 0x0024, 0x6090, 0x0024, 0x3800, 0x0024, /*  3d0 */
  0xf400, 0x4010, 0x3000, 0x0024, 0x0030, 0x0190, 0x2800, 0x7900, /*  3d8 */
  0x3800, 0x0024, 0x3000, 0x0024, 0x6080, 0x0024, 0x0000, 0x0024, /*  3e0 */
  0x2800, 0x8395, 0x0000, 0x0024, 0x0030, 0x0352, 0x0000, 0x0082, /*  3e8 */
  0x0006, 0x1350, 0xb886, 0x0040, 0x30f0, 0x4024, 0x4cd2, 0x0024, /*  3f0 */
  0x3810, 0x0024, 0x38f0, 0x4024, 0x3a00, 0x0024, 0x3010, 0x0024, /*  3f8 */
  0x30f0, 0x4024, 0x0030, 0x0390, 0x2800, 0x7900, 0x4180, 0x2001, /*  400 */
  0x4090, 0x0024, 0x3800, 0x0024, 0x0030, 0x0250, 0x3800, 0x0024, /*  408 */
  0x0006, 0x1290, 0x3000, 0x0024, 0x6090, 0x0024, 0x3800, 0x0024, /*  410 */
  0x0006, 0x0850, 0x3004, 0x8024, 0x3223, 0x0024, 0x32e0, 0x4024, /*  418 */
  0x6100, 0x0024, 0x0000, 0x0024, 0x2800, 0x8b01, 0x0000, 0x0024, /*  420 */
  0x3233, 0x0024, 0x3804, 0x8024, 0x3200, 0x0024, 0x6080, 0x0024, /*  428 */
  0x0006, 0x0300, 0x2800, 0x8998, 0x0000, 0x0024, 0x3800, 0x0024, /*  430 */
  0x0006, 0x0850, 0x3004, 0x0024, 0x3013, 0x0024, 0x3000, 0x0024, /*  438 */
  0x0006, 0x1290, 0x3800, 0x0024, 0x0006, 0x0850, 0x3004, 0x0024, /*  440 */
  0x3000, 0x0024, 0x0006, 0x1290, 0x6080, 0x0024, 0x3000, 0x0024, /*  448 */
  0x2800, 0x8f95, 0xf400, 0x4010, 0x3000, 0x0024, 0x0030, 0x0210, /*  450 */
  0x0000, 0x0005, 0x0000, 0x0201, 0xa014, 0x4004, 0x1fff, 0xfe01, /*  458 */
  0xae12, 0x0024, 0xc200, 0x0024, 0x2800, 0x8000, 0x3800, 0x0024, /*  460 */
  0x2800, 0x8d40, 0x3009, 0x0000, 0x0007, 0x0001, 0x8240, 0x0006, /*  468 */
  0x00f4, 0x003f, 0xff42, 0x0007, 0x9250, 0x0030, 0x1092, 0xb880, /*  470 */
  0x184c, 0x3e12, 0x0024, 0x3800, 0x0024, 0x0030, 0x0290, 0x38f0, /*  478 */
  0x0024, 0x3800, 0x0024, 0x0030, 0x0050, 0x3000, 0x4024, 0xb122, /*  480 */
  0x0024, 0x6894, 0x2001, 0x0000, 0x0141, 0x3a70, 0x4024, 0x0004, /*  488 */
  0x1fc1, 0x3a00, 0x4024, 0x0030, 0x0001, 0x0030, 0x00d2, 0x3a00, /*  490 */
  0x4024, 0x0030, 0x0552, 0x3a10, 0x0024, 0x3a00, 0x0024, 0x3000, /*  498 */
  0x4024, 0xc122, 0x0024, 0x3800, 0x4024, 0x0000, 0x03c1, 0x0030, /*  4a0 */
  0x05d0, 0x3820, 0x4024, 0x3800, 0x0024, 0x0000, 0x3fc0, 0x0030, /*  4a8 */
  0x02d0, 0x3000, 0x4024, 0x2912, 0x1400, 0xb104, 0x0024, 0x0006, /*  4b0 */
  0x1312, 0x6802, 0x0024, 0x000d, 0xac00, 0x6012, 0x2801, 0x0000, /*  4b8 */
  0x0024, 0x2800, 0x9ac1, 0x0000, 0x0024, 0x3a00, 0x0024, 0x2909, /*  4c0 */
  0x1b40, 0x3613, 0x0024, 0x0000, 0x1905, 0x0000, 0x0084, 0x2908, /*  4c8 */
  0xbe80, 0x3613, 0x0024, 0x0000, 0x0000, 0x0006, 0x0302, 0x4002, /*  4d0 */
  0x0024, 0x4012, 0x0024, 0x4212, 0x0024, 0xf400, 0x4050, 0x3000, /*  4d8 */
  0x4024, 0x6182, 0x0024, 0x0006, 0x0350, 0x2800, 0xa3c8, 0x0000, /*  4e0 */
  0x0024, 0x4002, 0x0024, 0x4014, 0x0024, 0x0006, 0x0301, 0x4124, /*  4e8 */
  0x0024, 0x0000, 0x0081, 0x4212, 0x0024, 0x4002, 0x4050, 0x4014, /*  4f0 */
  0x0003, 0x0006, 0x0301, 0x4122, 0x0024, 0x6192, 0x0024, 0x6090, /*  4f8 */
  0x4050, 0x3000, 0x4024, 0x0006, 0x0910, 0x6312, 0x0024, 0x6194, /*  500 */
  0x0001, 0x4122, 0x0024, 0x2800, 0x9c80, 0x3800, 0x4024, 0x0006, /*  508 */
  0x0991, 0x0006, 0x12d2, 0x3000, 0x0024, 0x0006, 0x1290, 0x3a00, /*  510 */
  0x0024, 0x3800, 0x0024, 0xf400, 0x4010, 0x293e, 0xd480, 0x0000, /*  518 */
  0x0580, 0x003f, 0xffc3, 0x003f, 0xf502, 0x0014, 0x9240, 0x0030, /*  520 */
  0x0210, 0x3800, 0x0024, 0x0006, 0x1350, 0x0000, 0x0580, 0x3200, /*  528 */
  0x4024, 0x4102, 0x0024, 0x3a00, 0x4024, 0x3810, 0x8024, 0x38f0, /*  530 */
  0xc024, 0x0006, 0x08d0, 0x3800, 0x0024, 0x0000, 0x8280, 0x0030, /*  538 */
  0x0690, 0xb880, 0x2080, 0x3800, 0x0024, 0x3800, 0x0024, 0x0000, /*  540 */
  0x0100, 0x0030, 0x0010, 0x3000, 0x584c, 0xb100, 0x0024, 0x0000, /*  548 */
  0x0024, 0x2800, 0xae05, 0x0000, 0x0024, 0x003f, 0xfec1, 0x3000, /*  550 */
  0x1bcc, 0xb010, 0x0024, 0x2908, 0x0b80, 0x3800, 0x0024, 0x3613, /*  558 */
  0x0024, 0x2910, 0x0180, 0x0000, 0xaac8, 0x0007, 0x0001, 0x1806, /*  560 */
  0x0006, 0x8007, 0x0000, 0x0006, 0x002f, 0x0010, 0x17ff, 0x0000, /*  568 */
  0x1a00, 0x1dff, 0x0000, 0x1f00, 0x3fff, 0x0001, 0x0000, 0x17ff, /*  570 */
  0x0001, 0x1c00, 0x3fff, 0x0001, 0xe000, 0xfffd, 0xffff, 0x0000, /*  578 */
  0x0000, 0x180c, 0x180c, 0x0000, 0x0000, 0x0000, 0x4952, 0x4646, /*  580 */
  0xffff, 0xffff, 0x4157, 0x4556, 0x6d66, 0x2074, 0x0010, 0x0000, /*  588 */
  0x0001, 0x0002, 0xbb80, 0x0000, 0xee00, 0x0002, 0x0004, 0x0010, /*  590 */
  0x6164, 0x6174, 0xffff, 0xffff, 0x0006, 0x8006, 0x0000, 0x0006, /*  598 */
  0x0005, 0x183c, 0x183c, 0x0000, 0x0020, 0x0040, 0x0006, 0x8003, /*  5a0 */
  0x0000, 0x0007, 0x0001, 0x5bc0, 0x0006, 0x0009, 0x801c, 0x7fe4, /*  5a8 */
  0x8039, 0x804e, 0x7fb2, 0x809d, 0x809c, 0x7f64, 0x8139, 0x0007, /*  5b0 */
  0x0001, 0x82ba, 0x0006, 0x002a, 0x3e11, 0xb807, 0x3009, 0x384a, /*  5b8 */
  0x3e11, 0x3805, 0x3e10, 0xb803, 0x3e00, 0x4442, 0x0001, 0x800a, /*  5c0 */
  0xbf8e, 0x8443, 0xfe06, 0x0045, 0x3011, 0x0401, 0x545e, 0x0385, /*  5c8 */
  0x525e, 0x2040, 0x72ce, 0x1bc1, 0x48ba, 0x9803, 0x4588, 0x4885, /*  5d0 */
  0x6fee, 0x1bc2, 0x4ffe, 0x9805, 0xf6fe, 0x1bc4, 0xf7f0, 0x2046, /*  5d8 */
  0x3801, 0xdbca, 0x2000, 0x0000, 0x36f1, 0x9807,
};

#endif
