/*
MSGEQ7 Library for interfacing to the MSGEQ7 Seven Band Grapic Equalizer chip made by Mixed Signal Integration

Chris Wilson
twilson8@gatech.edu
10/16/2013
*/

#ifndef MBED_MSGEQ7_H
#define MBED_MSGEQ7_H
 
#include "mbed.h"
 
class MSGEQ7 {
public:
    MSGEQ7(PinName reset, PinName strobe, PinName analog);
    void readByte();
    void readInt(int max);
    unsigned char freqDataByte[7]; //Byte array to store frequency data
    int freqDataInt[7]; //Int array for storing frequency data
  
private:  
    DigitalOut _reset; //Reset line
    DigitalOut _strobe; //Strobe line
    AnalogIn _analog; //Analog input from chip
    
    float read();
};
 
#endif
