/*
MSGEQ7 Library for interfacing to the MSGEQ7 Seven Band Grapic Equalizer chip made by Mixed Signal Integration

Chris Wilson
twilson8@gatech.edu
10/16/2013
*/

#include "MSGEQ7.h"
#include "mbed.h"

MSGEQ7::MSGEQ7(PinName reset, PinName strobe, PinName analog):
        _reset(reset), _strobe(strobe), _analog(analog) {
 
    // Initial condition of output enables
    _reset = 0;
    _strobe = 1;
}

/* The user is given two choices as to what format the data is returned to them in:
    1. One byte - readByte
    2. Integer - readInt
*/

float MSGEQ7::read(){
    float reading = 0.0;
    _strobe = 0;
    wait_us(30); //Wait 30us for output to settle
    reading = _analog;
    _strobe = 1;
    return reading;
}


// readByte() reads the frequency values then stores them in unsigned char array freqDataByte,
// with each frequency magnitude between 0 to 255
void MSGEQ7::readByte() {
    _reset = 1;
    _reset = 0;
    
    // Read all 7 frequency values and store them in the array
    for (int i = 0; i < 7; i++){
        freqDataByte[i] = char(read() * 255); //Mult by 255 to properly scale reading
    }
}


// readInt() reads the frequency values, then stores them in integer array freqDataInt, 
// with each frequency magnitude between 0 to a value 'max' specified by the user
void MSGEQ7::readInt(int max) {
    _reset = 1;
    _reset = 0;
    
    // Read all 7 frequency values and store them in the array
    for (int i = 0; i < 7; i++){
        freqDataInt[i] = int(read() * max); //Mult by 'max' to properly scale reading
    }
}