// LCD_Spectrum_Analyzer
// Created by Chris Wilson
// 10/16/2013

// NOTE: Contains LCD Custom Character code from Lluis Nadal

#include "mbed.h"
#include "MSGEQ7.h"
#include "TextLCD.h"

#define MAX 15

MSGEQ7 eq(p13, p14, p15); //reset, strobe, analog
TextLCD lcd(p30, p29, p28, p27, p26, p25); // rs, e, d4-d7

// Defines LCD bus to write data.
BusOut Lcd_pins(p28, p27, p26, p25); // d4, d5, d6, d7
DigitalOut rs_pin(p30); // LCD pin rs (register select.)
DigitalOut e_pin(p29);  // LCD pin e (enable).

//This data is 8 LCD characters representing an 8-level bar graph
char levels[8][8] = {
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0x1F},
    {0x00,0x00,0x00,0x00,0x00,0x1F,0x1F,0x1F},
    {0x00,0x00,0x00,0x00,0x1F,0x1F,0x1F,0x1F},
    {0x00,0x00,0x00,0x1F,0x1F,0x1F,0x1F,0x1F},
    {0x00,0x00,0x1F,0x1F,0x1F,0x1F,0x1F,0x1F},
    {0x00,0x1F,0x1F,0x1F,0x1F,0x1F,0x1F,0x1F},
    {0x1F,0x1F,0x1F,0x1F,0x1F,0x1F,0x1F,0x1F}
};

/* Code from Lluis Nadal
http://mbed.org/users/lnadal/code/Lcd_Custom_Char/
*/
// Because we use 4 bit LCD, data must be sent in two steps.
void writePort(int value) {

    Lcd_pins = value >> 4;  // Shifts 4 bit right.
    wait(0.000040f); // Wait 40us.
    e_pin = 0;
    wait(0.000040f);
    e_pin = 1;
    Lcd_pins = value;
    wait(0.000040f);
    e_pin = 0;
    wait(0.000040f);
    e_pin = 1;
}

/* Code from Lluis Nadal
http://mbed.org/users/lnadal/code/Lcd_Custom_Char/
*/
void createChars(){
    for (int j=0; j<8; j++) {
        rs_pin = 0; // We send a command.

        /* 0X40 is the initial CGRAM address. Because each character needs a total amount of 8 memory 
        locations, we increment addres in 8 units after each character.
        */
        writePort(0x40+8*j);

        // Writes data.
        rs_pin = 1; // We send data.
        
        for (int i=0; i<8; i++) {
            writePort(levels[j][i]);
        }
    }
}


int main() {
    int i = 0;
    lcd.cls();
    createChars();
    
    while(1) {
        eq.readInt(MAX); //Read in frequency data, mapped to a max number of 15
        
        for(i = 0; i < 7; i++){
            
            lcd.locate(i, 1); //Draw second (lower) row first
            if(eq.freqDataInt[i] > 7){ //Is the lower level maxed out?
                lcd.putc(7); // If maxed out, display full bars
            }else{
                lcd.putc(eq.freqDataInt[i]);
            }
            
            lcd.locate(i, 0); //Draw first (upper) row
            if(eq.freqDataInt[i] < 8){
                lcd.putc(32); //If empty, draw a space (' ')
            }else{
                lcd.putc(eq.freqDataInt[i] - 8);
            }
        }
        
    }
}
