#include "mbed.h"
#include "Adafruit_SSD1306.h"
DigitalOut myled(LED1);

/*==> Interface Display <==*/
I2C I2CDisp(PA_10, PA_9);
Adafruit_SSD1306_I2c Disp(I2CDisp,PB_0);

/*==> Interface Virtual COM PORT STProgrammer <==*/
Serial pc(SERIAL_TX, SERIAL_RX);


/* ==> Interface BNO_055  Shuttle Board <== */
Serial BNO(PB_6, PB_7);
DigitalOut BNO_RST(PB_1);
DigitalOut BNO_InterfaceSEL(PA_0);



int main() {
    /*Display Initialisierung*/
    Disp.clearDisplay();
    Disp.setRotation(2);
    Disp.printf("Hallo Davi \n");
    Disp.printf("Siehe Dokumente ... \n");
    Disp.display();
    /* HELLO World PC*/
    pc.printf("Hallo Davi !\n");
    /* Initialisierung BNO055*/
    BNO_RST = 1; // Reset Altive Low
    BNO_InterfaceSEL = 1; // Select UART Interface 
    BNO.baud(115200);
    /*Format Default 8N1 = 8data, no Parity bit, one Stop bit*/
    
    
    
    while(1) {
        myled = 1; // LED is ON
        wait(0.2); // 200 ms
        myled = 0; // LED is OFF
        pc.printf("Hallo Davi !\n");
        wait(1.0); // 1 sec
    }
}
