#include "mbed.h"
#include "TextLCD.h"
#include "cdef.h"
#include "I2C.h"
DigitalOut myled(LED1);
TextLCD display(PA_9, PC_7, PB_5, PB_4, PB_10, PA_8, TextLCD::LCD16x2);
Serial pc(SERIAL_TX, SERIAL_RX);



/******************************************************
* void vInitSystemClock(void)
* Purpose:
*   Initialisiert Clocksystem HSI,HSE,PLL, Setzt HSE als
*   Taktquelle und PLL für SystemClock = 84 Mhz.
*   Aktiviert Clock Secuity System für fall das HSE versagt
* Parameter:
*   -Keine Parameter-
* Return value:
*   -Keine Return Values
* Interrupt:
*   Im HSE Ausfall wird RCC Interrupt aufgerufen
*******************************************************/
void vInitSystemClock(void)
{

   /***Flash wait states 2 */
   FLASH->ACR |= Bit1 ;
   /** Enable the High Speed Internal Clock and wait for HSI to be stable.*/
   RCC->CR |= RCC_CR_HSION;
   while (!(RCC->CR & RCC_CR_HSIRDY));
   RCC->CFGR = 0x00000000;                                        // HSI enabled and used as System Clock. No Clock Division.
   while( (RCC->CFGR & RCC_CFGR_SWS)  != RCC_CFGR_SWS_HSI );  // WAITING HSI IS SYSTEM CLOCK
    /**ENABLE HSE CLOCK and wait for HSE to be stable */
    RCC->CR |= RCC_CR_HSEON ;
    while( (RCC->CR & RCC_CR_HSERDY)  == 0);
    RCC->CR &= ~(RCC_CR_PLLI2SON
               | RCC_CR_CSSON
               | RCC_CR_PLLON)
               ;   // Turn off PLL and CSS (clock security system).
     while(RCC->CR & RCC_CR_PLLRDY);  // WAITING PLL OF
   /** Disable all clock generated interrupts. */
   RCC->CIR = 0x00000000;
   RCC->PLLCFGR = 0x20000000;                                       // SETZE PLL COMFIG REGISTERINHALT KOMPLETT AUF 0
    /** SETTINGS FOR PLL OVER HSE 8Mhz **/
      RCC->PLLCFGR |=  (8 << 0)                                       // 16 / 8 = 2MHz
                |(168 << 6)                                     // 2 * 168 =  336MHz
                |(1 << 16)                                      // 336MHz / 4 = 84MHz (0x01 corresponds to /4)
                |(RCC_PLLCFGR_PLLSRC_HSI)                       // HSI selected.
                |(7 << 24);                                     // 336Mhz / 7 = 48MHz
   RCC->CFGR |= RCC_CFGR_PPRE1_DIV2;                              // Low speed peripheral clock setup set to 42Mhz. (84Mhz / 2)
   RCC->CR |= (RCC_CR_PLLON);                                     // Start the PLL clock.
   while (!(RCC->CR & RCC_CR_PLLRDY));                            // Wait for the PLL to start.
   RCC->CFGR &= ~(RCC_CFGR_SW);                                    // SET PLL AS SYSTEM CLOCK
   RCC->CFGR |= RCC_CFGR_SW_PLL;
   while ((RCC->CFGR & RCC_CFGR_SWS ) != RCC_CFGR_SWS_PLL);       // Wait for configuration to take place.
   /** ENABLE CLOCK SECUITY SYSTEM */
   RCC->CR |= Bit19 ;
   NVIC_EnableIRQ(RCC_IRQn);

}








int main()
{
    display.cls();
     vInitSystemClock();
    PRESSURE_vInit();
    PRESSURE_vget_CALDATA();
    PRESSURE_vwrite_EEPROM_REGISTER(BMP180_register_CONTROLL,0x2E);
    wait(0.2);
    PRESSURE_DATA.i_RAW_TEMPERATUR = PRESSURE_vread_EEPROM_REGISTER(BMP180_register_ADC_ERG);
    wait(0.1);
    PRESSURE_vwrite_EEPROM_REGISTER(BMP180_register_CONTROLL,0xB4); // HIGH RESULUTUIN
    wait(0.1);
    PRESSURE_DATA.i_RAW_PRESSURE =   ( (PRESSURE_vread_EEPROM_REGISTER(BMP180_register_ADC_ERG))<<8 ) >>(8-BMP180_oss_high_resulution );
    PRESSURE_vCALCULATE_TEMPANDPRESSURE();

    while(1) {
        myled = 1; // LED is ON
        PRESSURE_vwrite_EEPROM_REGISTER(BMP180_register_CONTROLL,0x2E);
        wait(0.2);
        PRESSURE_DATA.i_RAW_TEMPERATUR = PRESSURE_vread_EEPROM_REGISTER(BMP180_register_ADC_ERG);
        PRESSURE_vwrite_EEPROM_REGISTER(BMP180_register_CONTROLL,0xB4); // HIGH RESULUTUIN
        wait(0.1);
        PRESSURE_DATA.i_RAW_PRESSURE =   ( (PRESSURE_vread_EEPROM_REGISTER(BMP180_register_ADC_ERG))<<8 ) >>(8-BMP180_oss_high_resulution );
        PRESSURE_vCALCULATE_TEMPANDPRESSURE();
        myled = 0; // LED is OFF
        wait(0.1); // 1 sec
        display.cls();
        display.printf("TEMP:%d.%d C\n", (PRESSURE_DATA.i_TEMPERATURE)/10, (PRESSURE_DATA.i_TEMPERATURE)%10 );
        display.locate(0,1);
        display.printf("Press: %d PA\n",PRESSURE_DATA.i_PRESSURE  );
        pc.printf("TestPrintPCDisplay\n");
    }
}
