#ifndef I2C_H
#define I2C_H

#include "stm32f4xx.h"
#include "cdef.h"


#define BMP180_register_CONTROLL 0xF4
#define BMP180_register_ADC_ERG 0xF6
#define BMP180_oss_high_resulution 2
#define BMP180_adress_write 0xEE
#define BMP180_adress_read 0xEF
#define BMP180_register_AC1 0xAA
#define BMP180_register_AC2 0xAC
#define BMP180_register_AC3 0xAE
#define BMP180_register_AC4 0xB0
#define BMP180_register_AC5 0xB2
#define BMP180_register_AC6 0xB4
#define BMP180_register_B1 0xB6
#define BMP180_register_B2 0xB8
#define BMP180_register_MB 0xBA
#define BMP180_register_MC 0xBC
#define BMP180_register_MD 0xBE

//=============================================================
//===========Neue Definitionen für Laser Radar Sensor ==========

#define LRadar_adress_write 0xC4
#define LRadar_adress_read 0xC5
#define LRadar_register_Controll 0x00
#define LRadar_register_erg_2bread 0x8f
#define LRadar_start_measurment 0x04






typedef struct BMP180_CAL_DATA_TYPEDEF{
short AC1;
short AC2;
short AC3;
unsigned short AC4;
unsigned short AC5;
unsigned short AC6;
short B1;
short B2;
short MB;
short MC;
short MD;
}BMP180_CAL_DATA_TYPEDEF;

typedef struct PRESSURE_DATA_TYPEDEF{
byte b_TASK_STATEMASCHINE;
long i_RAW_TEMPERATUR;
long i_RAW_PRESSURE;
long i_TEMPERATURE;
long i_PRESSURE;
}PRESSURE_DATA_TYPEDEF;

extern PRESSURE_DATA_TYPEDEF PRESSURE_DATA;
extern BMP180_CAL_DATA_TYPEDEF BMP180_CAL_DATA;

/**Initalisate THE PRESSURE AND READ THE CALLIBRATION DATA */
void PRESSURE_vInit(void);
void PRESSURE_vget_CALDATA(void);
void PRESSURE_vwrite_EEPROM_REGISTER(byte b_register, byte data);
long PRESSURE_vread_EEPROM_REGISTER(byte b_register);
void PRESSURE_vCALCULATE_TEMPANDPRESSURE(void);
void PRESSURE_vTASK(unsigned long bID);


byte I2C_write(byte bSlaveWriteAdress, byte bRegister, byte bValue);  // 1 hat geklabt ; 0 ERROR 
byte I2C_read(byte bSlaveWriteAdress,byte bSlaveReadAdress, byte bRegister, byte bNumOfBytes, byte *abArray); // bNumOfByte absolute zahlen zwisch 
// 2  = es wertden 2 bytes eingelesen 
#endif
