#include "I2C.h"
//#include "lcd.h"
//#include "stm32f4xx_i2c.h"
//#include "stm32f4xx_gpio.h"
//#include "stm32f4xx_rcc.h"
BMP180_CAL_DATA_TYPEDEF BMP180_CAL_DATA;
PRESSURE_DATA_TYPEDEF PRESSURE_DATA;


void PRESSURE_vInit(void){

  //  uint32_t temp;
     uint32_t temp = 0x00;
  uint32_t temp_2 = 0x00;
#if 0
RCC->AHB1ENR |= Bit1 ; // GPIOB ENABLE
RCC->APB1ENR |= Bit21 ; // I2C1 clock enable

GPIOB->MODER |= Bit17 | Bit19 ;  // SET PB8 & PB9 As alternating function
GPIOB->MODER &= ~(Bit16 | Bit18);
GPIOB->AFR[1] |= Bit2 | Bit6 ; // PB8 & PB9 AF4
GPIOB->AFR[1] &= ~(Bit0 | Bit1 | Bit3 |
                   Bit4 | Bit5 | Bit7 );
GPIOB->OTYPER |= Bit8 | Bit9 ; // OPEN TRAIN



I2C1->CR2 = 0x0000; // RESET VALUE
//I2C1->CR2 |= Bit1 ;  // PHERIVERIAL CLOCK = 2MHz
I2C1->CR2 |= 0b101010; // SET APB SPEEZ TO 42 MHZ

I2C1->CCR = 0x0000; // RESET VALUE AND SM MODE // SLOT DUTY MODE

#if 1
/**GESCHWINDIGKEIT SLOW MODE 100000 HZ*/
I2C1->CCR |= 420; // GESCHWINDIGKEIT 100 000 Hz (42Mhz / 100000)

I2C1->TRISE = 43; // MAXIMUM RISE TIME AT 42 MHZ
// I2C1->TRISE |= Bit3 | Bit0 ;

#else
/**GESCHWINDIGKEIT 350 kHz FAST MODE MAX EINSTELLBAR IN PLL CONFIGURATION (MAX 400k nach datenblatt)*/
I2C1->CCR |= Bit15 ; // FAST MODE
I2C1->CCR |= 112 ; // FREQUENCY 375 kHz (42Mhz / 350000Hz) = 120
I2C1->TRISE = 13; // MAXIMUM RISE TIME
#endif


I2C1->CR1 = 0x0000;
I2C1->CR1 |= Bit10; // AKNOLAGE ENABLE


I2C1->CR1 |= Bit0 ; // ENABLE
I2C1->OAR1 |= Bit15;

#else



RCC->AHB1ENR |= Bit1 ; // GPIOB ENABLE
RCC->APB1ENR |= Bit21 ; // I2C1 clock enable




GPIOB->MODER |= Bit17 | Bit19 ;  // SET PB8 & PB9 As alternating function
GPIOB->MODER &= ~(Bit16 | Bit18);
//temp = 0;
//temp

GPIOB->OTYPER |= Bit8 | Bit9 ; // OPEN TRAIN
GPIOB->OSPEEDR |= Bit17 | Bit19 ;
GPIOB->OSPEEDR &= ~(Bit16 | Bit18 );

GPIOB->PUPDR &= ~(   Bit16 | Bit17 | Bit18 | Bit19  );

GPIOB->PUPDR |= Bit16 | Bit18 ;


//GPIOB->AFR[1] |= Bit2 | Bit6 ; // PB8 & PB9 AF4
//GPIOB->AFR[1] &= ~(Bit0 | Bit1 | Bit3 |
  //                 Bit4 | Bit5 | Bit7 );

//PIN8
  temp = ((uint32_t)(0x04) << ((uint32_t)((uint32_t)0x08 & (uint32_t)0x07) * 4)) ;
  GPIOB->AFR[0x08 >> 0x03] &= ~((uint32_t)0xF << ((uint32_t)((uint32_t)0x08 & (uint32_t)0x07) * 4)) ;
  temp_2 = GPIOB->AFR[0x08 >> 0x03] | temp;
  GPIOB->AFR[0x08 >> 0x03] = temp_2;


//PIN9
 temp = ((uint32_t)(0x04) << ((uint32_t)((uint32_t)0x09 & (uint32_t)0x07) * 4)) ;
  GPIOB->AFR[0x09 >> 0x03] &= ~((uint32_t)0xF << ((uint32_t)((uint32_t)0x09 & (uint32_t)0x07) * 4)) ;
  temp_2 = GPIOB->AFR[0x09 >> 0x03] | temp;
  GPIOB->AFR[0x09 >> 0x03] = temp_2;







I2C1->CR2 = 0x0000; // RESET VALUE
//I2C1->CR2 |= Bit1 ;  // PHERIVERIAL CLOCK = 2MHz
//I2C1->CR2 |= 0b101010; // SET APB SPEEZ TO 42 MHZ
I2C1->CR2 |= 0x2A; // SET APB SPEEZ TO 42 MHZ
I2C1->CCR = 0x0000; // RESET VALUE AND SM MODE // SLOT DUTY MODE

#if 1
/**GESCHWINDIGKEIT SLOW MODE 100000 HZ*/
I2C1->CCR |= 420; // GESCHWINDIGKEIT 100 000 Hz (42Mhz / 100000)

I2C1->TRISE = 43; // MAXIMUM RISE TIME AT 42 MHZ
// I2C1->TRISE |= Bit3 | Bit0 ;

#else
/**GESCHWINDIGKEIT 350 kHz FAST MODE MAX EINSTELLBAR IN PLL CONFIGURATION (MAX 400k nach datenblatt)*/
I2C1->CCR |= Bit15 ; // FAST MODE
I2C1->CCR |= 112 ; // FREQUENCY 375 kHz (42Mhz / 350000Hz) = 120
I2C1->TRISE = 13; // MAXIMUM RISE TIME
#endif


I2C1->CR1 = 0x0000;
I2C1->CR1 |= Bit10; // AKNOLAGE ENABLE


I2C1->CR1 |= Bit0 ; // ENABLE
I2C1->OAR1 |= Bit15;



#endif



//PRESSURE_vget_CALDATA();
}


void PRESSURE_vTASK(unsigned long  bID){
switch(PRESSURE_DATA.b_TASK_STATEMASCHINE){
case 0:
/**START TEMPERATUR MEASUREMENT*/
PRESSURE_vwrite_EEPROM_REGISTER(BMP180_register_CONTROLL,0x2E); // TEMPERATUR MEASUREMENT
PRESSURE_DATA.b_TASK_STATEMASCHINE = 1;
    break;
case 1:
/** REAT TEMP_DATA*/
PRESSURE_DATA.i_RAW_TEMPERATUR = PRESSURE_vread_EEPROM_REGISTER(BMP180_register_ADC_ERG);
PRESSURE_DATA.b_TASK_STATEMASCHINE = 2;
break;
case 2:
/**START PRESSURE MEASUREMENT*/
PRESSURE_vwrite_EEPROM_REGISTER(BMP180_register_CONTROLL,0xB4); // HIGH RESULUTUIN
PRESSURE_DATA.b_TASK_STATEMASCHINE = 3;
break;
case 3:
/**REAT PRESSURE DATA*/
PRESSURE_DATA.i_RAW_PRESSURE =   ( (PRESSURE_vread_EEPROM_REGISTER(BMP180_register_ADC_ERG))<<8 ) >>(8-BMP180_oss_high_resulution );
//PRESSURE_DATA.b_TASK_STATEMASCHINE = 2;

PRESSURE_DATA.b_TASK_STATEMASCHINE = 4;
    break;
case 4:
/**KALCULATE TEMPERATUR AND PRESSURE*/
PRESSURE_vCALCULATE_TEMPANDPRESSURE();
PRESSURE_DATA.b_TASK_STATEMASCHINE = 0;
    break;
default: PRESSURE_DATA.b_TASK_STATEMASCHINE = 0;
}


}


void PRESSURE_vCALCULATE_TEMPANDPRESSURE(void){
long X1,X2,B5,B6,X3,B3,p ;
unsigned long B4,B7;

X1 = (  PRESSURE_DATA.i_RAW_TEMPERATUR - BMP180_CAL_DATA.AC6 ) * BMP180_CAL_DATA.AC5 / 0x8000 ;
X2 = (  BMP180_CAL_DATA.MC * 0x800     )/(X1 + BMP180_CAL_DATA.MD);
B5 = (  X1 + X2 );

PRESSURE_DATA.i_TEMPERATURE = (  B5 + 8  )/ 0x10;

B6 = B5 - 4000;

X1  = (  BMP180_CAL_DATA.B2  *(  B6*B6/ 0x1000  )) /0x800;

X2 = (  BMP180_CAL_DATA.AC2 * B6)/0x800;

X3 = X1 + X2;

B3 = (((   BMP180_CAL_DATA.AC1 * 4 + X3) << BMP180_oss_high_resulution)+2)/4;

X1 = BMP180_CAL_DATA.AC3 * B6 / 0x2000;

X2 = (   BMP180_CAL_DATA.B1 * ( B6*B6 / 0x1000))/ 0x10000;

X3 = ((X1+X2)+2)/ 0x4;

B4 = BMP180_CAL_DATA.AC4 * (unsigned long)(X3 + 32768)/ 0x8000  ;

B7 = ( (unsigned long) PRESSURE_DATA.i_RAW_PRESSURE - B3)*(50000 >> BMP180_oss_high_resulution);

//p = (B7 / B4 )*2;
if( B7 <   0x80000000 ) p=(B7 * 2 )/B4;
else p = (B7 / B4 )*2;

X1 = ( p/0x100)*(p/0x100);

X1 = (X1 * 3038)/ 0x10000;

X2 = (-7357 * p)/ 0x10000;

p = p + (X1 + X2 + 3791) / 0x10 ;

PRESSURE_DATA.i_PRESSURE = p;
}




void PRESSURE_vget_CALDATA(void){
//LCD_vDrawString("PRESSURE-i2C2\0",100,80,1,0x0000);

 BMP180_CAL_DATA.AC1 =  PRESSURE_vread_EEPROM_REGISTER(BMP180_register_AC1);
 //LCD_vDrawString("PRESSURE-i2C3\0",100,60,1,0x0000);

 BMP180_CAL_DATA.AC2 = PRESSURE_vread_EEPROM_REGISTER(BMP180_register_AC2);
 BMP180_CAL_DATA.AC3 =  PRESSURE_vread_EEPROM_REGISTER(BMP180_register_AC3);
 BMP180_CAL_DATA.AC4 =  PRESSURE_vread_EEPROM_REGISTER(BMP180_register_AC4);
 BMP180_CAL_DATA.AC5 =  PRESSURE_vread_EEPROM_REGISTER(BMP180_register_AC5);
 BMP180_CAL_DATA.AC6 =  PRESSURE_vread_EEPROM_REGISTER(BMP180_register_AC6);
 BMP180_CAL_DATA.B1 =  PRESSURE_vread_EEPROM_REGISTER(BMP180_register_B1);
 BMP180_CAL_DATA.B2 =  PRESSURE_vread_EEPROM_REGISTER(BMP180_register_B2);
 BMP180_CAL_DATA.MB =  PRESSURE_vread_EEPROM_REGISTER(BMP180_register_MB);
 BMP180_CAL_DATA.MC =  PRESSURE_vread_EEPROM_REGISTER(BMP180_register_MC);
 BMP180_CAL_DATA.MD =  PRESSURE_vread_EEPROM_REGISTER(BMP180_register_MD);
}


/***EVT NOCH EIN ABSTURZ KRITERIUM */
long PRESSURE_vread_EEPROM_REGISTER(byte b_register){

/**EINLESEN VON ADC WERTEN ODER EEPORM DATEN  */
uint16_t local;
uint16_t MSB,LSB;
I2C1->CR1 |= Bit8; // ERZEUGEN STARTKONDITION
 //LCD_vDrawString("START\0",2,40,1,0x0000);

while((I2C1->SR1 & Bit0) == 0 );  // WHAITING START BIT GENERAITET
I2C1->DR = BMP180_adress_write;

 //LCD_vDrawString("START-G\0",50,40,1,0x0000);


while((I2C1->SR1 & Bit1) == 0 );  // WHAITING ADDR = 1

local = I2C1->SR2 ; // READ SR2 for Delete ADDR

I2C1->DR = b_register;

while( ((I2C1->SR1 & Bit7) == 0) && ((I2C1->SR1 & Bit2) == 0 ));  // WHAITING Data register Empte

I2C1->CR1 |= Bit9;

// GGF WEGMACHEN
for(local = 0; local <1000;local++); // WAIT TIME


I2C1->CR1 |= Bit10; // AKNOLLAGE ENABLE ;

I2C1->CR1 |= Bit8; // ERZEUGEN STARTKONDITION

while((I2C1->SR1 & Bit0) == 0 );  // WHAITING START BIT GENERAITET

I2C1->DR = BMP180_adress_read;

while((I2C1->SR1 & Bit1) == 0 );  // WHAITING ADDR = 1

local = I2C1->SR2 ; // READ SR2 for Delete ADDR

while( (I2C1->SR1 & Bit6 )== 0 ); // WHAIT DATA TRANSMIT

MSB = I2C1->DR ;
I2C1->CR1 &= ~Bit10; // NO ACNOLAGE BECAUSE LAST  BYTE
I2C1->CR1 |= Bit9; // STOP BETWEEN THE CURRENT TRANSFER
while( (I2C1->SR1 & Bit6 )== 0 ); // WHAIT DATA TRANSMIT
LSB = I2C1->DR ;

return (MSB<<8)|LSB ;
}




void PRESSURE_vwrite_EEPROM_REGISTER(byte b_register, byte data){
uint16_t local;

I2C1->CR1 |= Bit8; // START KONDITION

while((I2C1->SR1 & Bit0) == 0 );  // WHAITING START BIT GENERAITET
/**SENDEN ADRESSE */
I2C1->DR = BMP180_adress_write;

while((I2C1->SR1 & Bit1) == 0 );  // WHAITING ADDR = 1

local = I2C1->SR2 ; // READ SR2 for Delete ADDR


/**Senden erstes PACKET*/
I2C1->DR = b_register;

while((I2C1->SR1 & Bit7) == 0 );  // WHAITING Data register Empte

//local = I2C1->SR2 ; // READ SR2 for Delete ADDR
/**SENDEN Zweites Packet */
I2C1->DR = data;
while( ((I2C1->SR1 & Bit7) == 0) && ((I2C1->SR1 & Bit2) == 0 ));  // WHAITING Data register Empte
/**STOP CONDITION */
I2C1->CR1 |= Bit9;
}





byte I2C_write(byte bSlaveWriteAdress, byte bRegister, byte bValue){
uint16_t local;
I2C1->CR1 |= Bit8; // START KONDITION

while((I2C1->SR1 & Bit0) == 0 );  // WHAITING START BIT GENERAITET
/**SENDEN ADRESSE */
I2C1->DR = bSlaveWriteAdress;

while((I2C1->SR1 & Bit1) == 0 );  // WHAITING ADDR = 1

local = I2C1->SR2 ; // READ SR2 for Delete ADDR


/**Senden erstes PACKET*/
I2C1->DR = bRegister;

while((I2C1->SR1 & Bit7) == 0 );  // WHAITING Data register Empte

//local = I2C1->SR2 ; // READ SR2 for Delete ADDR
/**SENDEN Zweites Packet */
I2C1->DR = bValue;
while( ((I2C1->SR1 & Bit7) == 0) && ((I2C1->SR1 & Bit2) == 0 ));  // WHAITING Data register Empte
/**STOP CONDITION */
I2C1->CR1 |= Bit9;


return 1;
    }






byte I2C_read(byte bSlaveWriteAdress,byte bSlaveReadAdress, byte bRegister, byte bNumOfBytes, byte *abArray){ 
/**EINLESEN VON ADC WERTEN ODER EEPORM DATEN  */
uint16_t local;
byte i;

/*******************************************************/
// SEKTION 1 Auswahl des Registes durch write befehl
/*********************************************************/
I2C1->CR1 |= Bit8; // ERZEUGEN STARTKONDITION
while((I2C1->SR1 & Bit0) == 0 );  // WHAITING START BIT GENERAITET
I2C1->DR = bSlaveWriteAdress;
while((I2C1->SR1 & Bit1) == 0 );  // WHAITING ADDR = 1
local = I2C1->SR2 ; // READ SR2 for Delete ADDR
I2C1->DR = bRegister;
while( ((I2C1->SR1 & Bit7) == 0) && ((I2C1->SR1 & Bit2) == 0 ));  // WHAITING Data register Empte
I2C1->CR1 |= Bit9;
// GGF WEGMACHEN
for(local = 0; local <1000;local++); // WAIT TIME


/*******************************************************/
// SEKTION 2 Eigentliches Auslesen der Werte 
/*********************************************************/

I2C1->CR1 |= Bit10; // AKNOLLAGE ENABLE ;
I2C1->CR1 |= Bit8; // ERZEUGEN STARTKONDITION
while((I2C1->SR1 & Bit0) == 0 );  // WHAITING START BIT GENERAITET
I2C1->DR = bSlaveReadAdress;
while((I2C1->SR1 & Bit1) == 0 );  // WHAITING ADDR = 1
local = I2C1->SR2 ; // READ SR2 for Delete ADDR

for(i=0; i< bNumOfBytes-1; i++){
while( (I2C1->SR1 & Bit6 )== 0 ); // WHAIT DATA TRANSMIT
abArray[i] = I2C1->DR ;
}
i= bNumOfBytes-1;
I2C1->CR1 &= ~Bit10; // NO ACNOLAGE BECAUSE LAST  BYTE
I2C1->CR1 |= Bit9; // STOP BETWEEN THE CURRENT TRANSFER
while( (I2C1->SR1 & Bit6 )== 0 ); // WHAIT DATA TRANSMIT
abArray[i] = I2C1->DR ;


return 1;
}


