/***************************************************************************
* Titel        : LAB.C
*
* Description  : Labormodul "DIBI"
*
* Revision List:
  --------------------------------------------------------------------------
  Date     | Author          | Change
  --------------------------------------------------------------------------
  15.11.13 | J. Altenburg    | Ersterstellung
  --------------------------------------------------------------------------
           |                 |
  --------------------------------------------------------------------------
****************************************************************************/

/***************************************************************************
* HEADER-FILES (Only those that are needed in this file)
****************************************************************************/
/* Own header */
#include "lab.h"

/* Foreign headerfiles */
#include "lcd.h"
#include "picture.h"
#include "mbed.h"

DigitalOut      bLed2(LED4);
DigitalIn       bBtn1(p8);
AnalogIn        fpAnalog(p15);     /* Analogeingang */

#define PROF

/***************************************************************************
*   Variablen
****************************************************************************/
byte abPicture[160][120];  /*
Description:  Bildspeicher fuer Grauwertbild
*/

word awHisto[64] = {0}; /*
Description : Histogramm-Vektor
*/

lcd_t myLCD; /*
* Description : Zugriffstruktur für LCD
*/

spi_t mySPI; /*
* Description : dito. fuer SPI
*/

float fpAdcValue; /*
* Description : analoger Messwert
*/

/***************************************************************************
*   lokale Funktionsprototypen
***************************************************************************/


/***************************************************************************
*   Defines und Makros                                                       *
***************************************************************************/


/***************************************************************************
*   lokale Funktionen
****************************************************************************/
/* Umrechnen eines Farbwertes in einen Grauwert */
byte bRGB565ToGray(word wColor){
    byte bGray = 0;
    byte r,g,b;
    
    r = (wColor & 0xf800)>>11;
    g = (wColor & 0x07E0) >>5;
    b = (wColor & 0x001F) ;
    #if 1 
    bGray = ((r+b)*2 + g)/3; 
        
    #else 
    
    bGray  = (byte)     
    #endif 
         /*
     .... hier eigenen Code eintragen
     */
    return bGray;
    }

/* Umrechnen eines Grauwert in einen "unbunten" RGB565-Wert */
word wGrayToRGB565(byte bGray){
     word wNoColor;
     byte r,g,b;
     r = bGray /2;
     g= bGray;
     b = bGray / 2;
     wNoColor = (r <<11) + (g << 5) + b;
    return wNoColor;
    }


/* Umrechnen des Farbbildes in ein Grauwertbild
   Parameterübergabe erfolgt über Zeiger
   */
void vColorToGray(word *pColor, byte *pGray){
    word w;
    for(w = 0; w < 19200; w++){
        *pGray = bRGB565ToGray(*pColor);
        pGray++;
        pColor++;
        }
    }

/* Grauwertbild in Sektor 2 plazieren */
void vGrayToScreen2(byte *pGray){
    word wColor, v;
    byte x, y;
    x = y = 0;
    for(v = 0; v < 19200; v++){
        wColor = wGrayToRGB565(*pGray);
        pGray++;
        lcd_setPixel(&myLCD, 120 + y, 160 + x, wColor);
        y++;
        if(y > 119){
            y = 0;
            x++;
            }
        }
    }

/* Grauwertbild in Sektor 3 plazieren */
void vGrayToScreen3(byte *pGray){
 
  word wColor, v;
    byte x, y;
    x = y = 0;
    for(v = 0; v < 19200; v++){
        wColor = wGrayToRGB565(*pGray);
        pGray++;
        lcd_setPixel(&myLCD, y, 160 + x, wColor);
        y++;
        if(y > 119){
            y = 0;
            x++;
            }
        }
}



/* Histogramm in Sektor 4 zeichnen */
void vDrawHisto(byte *pGray){
    word y, wMax = 0;
    byte i, j, n;
    /* Histogrammvektor initialisieren ... ihre Sache */

    /* Histogrammvektor berechnen      ...  bitte tun */
    /* Werte normieren                 ...  wenn notwendig */
    
    //word awHisto[64] = {0}; /*
    //byte abPicture[160][120];  /*
    
    for(i=0;i<64;i++) awHisto[i] = 0; 
    
    
    for(i=0;i<120;i++){
        for(j=0;j<160;j++)awHisto[abPicture[i][j]] +=1;
    }
    
    
    /**ERmittlung des Maximalwertes */
    wMax = awHisto[0];
    for(i=1;i<64;i++){
        if( awHisto[i] > wMax)wMax = awHisto[i];
    }
    
    /* ab hier Bildaufbau */
    LCD_vFillRectangle(&myLCD, 10, 140, 128, 84, GRAY1);    /* grauer Hintergrund */
                //LCD_vSetPixel(&myLCD, 200,300, BRIGHT_RED)
                //                       y   x  
                
    for(i = 0; i < 128; i = i + 16){
        LCD_vDrawVline(&myLCD, 20+i, 140, 84, GRAY2);
        }
    for(i = 0; i < 64; i++){                                /* die möglichen Werte darstellen */  
        n = i*2;
        y = i;                                              // erzeugt einen Keil 
        for(j = 0; j <  ( awHisto[i] * 64 / wMax)   ; j++){
            LCD_vSetPixel(&myLCD, 20+j, 10+n, BRIGHT_RED);
           // LCD_vSetPixel(&myLCD, 20+j, 11+n, BRIGHT_RED);
            }
        }
    
        
   // for(i = 0; i < 128; i = i + 16){
    //    LCD_vDrawVline(&myLCD, 20+i, 140, 84, GRAY2);
     //   }
    for(i = 0; i < 128; i++){
        LCD_vSetPixel(&myLCD, 84, 10+i, BLUE);
        }
    }



/* Grauwerte manipulieren
   *pGray zeigt auf die Grauwerte
   bValue bestimmt die Größenmanipulation
   */
void vChangeGray(byte *pGray, byte bValue){
       byte bGMin, bGMax, bWMax,bWMin;
    word x,y,l,h;
    word wColor ;
     bWMax = 63;
     bWMin = 0;
   
   for(x=0;x<64;x++)if( awHisto[x] > 0){ bGMin = x; break;}
   // Ermittlung von gMax
   for(x=63;x>=0;x--)if( awHisto[x] > 0){ bGMax = x; break;}
   
   lcd_drawNumber(&myLCD, bGMin, 1, 230, 1, BLACK);
   lcd_drawNumber(&myLCD, bGMax, 50, 230, 1, BLACK);

   
   byte abOnePiktureLine[160];
   // Jetzt Ermittlung der Neuen Werte mit Transferfunktion 
   // gneu (g) = (g- gmin) * (   (wmax+ wmin) / ( gmax - gmin ) ) 
       byte *ab=  &abPicture[0][0];
    #if 1
    /**Überschreiben des Grauwertbildes Mit neuem Bild */
      for(x = 0; x <19200; x++){
        if( ( ( *(ab + x) - bGMin) * (bWMax/(bGMax-bGMin)) ) >=0) 
              *(pGray + x) = ( *(ab + x) - bGMin) * (bWMax/(bGMax-bGMin)) * bValue   ;
              else 
            *(pGray+x) =0;
         }
        
    #else
    /** Keine Speicherung des Korregierten Bildes sondern Direkte Ausgabe aus screen */
    // l = x  h = y 
    l=0;
    h=0;
      for(x = 0; x <19200; x++){
        if( ( ( *(ab + x) - bGMin) * (bWMax/(bGMax-bGMin)) ) >=0) 
              wColor = wGrayToRGB565(( *(ab + x) - bGMin) * (bWMax/(bGMax-bGMin)) ) /*bValue */  ;
              else 
           wColor = wGrayToRGB565(0);
           
           lcd_setPixel(&myLCD, h, 160 + l, wColor);
           h++;
            if(h > 119){
            h= 0;
            l++;
            }
         }
    #endif

    }


/***************************************************************************
*    Initialisierung
*    angeschlossene Hardware aktivieren
*    Bildsektoren 1, 2 initialsieren
*    Histogramm aufbauen
****************************************************************************/
void LAB_vInit( void ){
    spi_init(&mySPI, p11, p12, p13, NC);
    spi_format(&mySPI, 8, 0, 0);
    spi_frequency(&mySPI, 25000000);
    LCD_vInit(&myLCD, &mySPI, p22, p23);
    LCD_vSetMode(&myLCD, LANDSCAPE);
    /* Blume in Sektor 1 zeichnen */
    LCD_vFillSprite(&myLCD, 0, 0, 159, 119, (short int*)&awBlume[0]);
    /* Grauwerte aus Farbbild ermitteln */
    vColorToGray((word*)&awBlume[0], &abPicture[0][0]);
    /* Grauwertbild in Sektor 2 zeichnen */
    vGrayToScreen2(&abPicture[0][0]);
    /* Histogramm in Sektor 4 zeichen */
    vDrawHisto(&abPicture[0][0]);
    }




/***************************************************************************
*    MMI-Main
*    diese Funktion wird alle 100 ms aufgerufen
****************************************************************************/
void LAB_vMain( void ){
    bLed2 = !bLed2;
   // float bADCDATA;
    byte i;
 
    /* heir die Anzeige des Analogwertes einbauen */
    byte abPictureCorrektet[120][160];
    
     fpAdcValue = fpAnalog.read();
     lcd_drawFloat(&myLCD,fpAdcValue*10, 3, 20, 125, 1, RED);
      if(!bBtn1) {
      
            //  vChangeGray(&abPictureCorrektet[0][0], 4);
              #if 0
              vGrayToScreen3(&abPictureCorrektet[0][0]);
                #else
                          vChangeGray(&abPicture[0][0], fpAdcValue*10);
                           vGrayToScreen3(&abPicture[0][0]);
                          vDrawHisto(&abPicture[0][0]);
                            
                #endif
        }
   }


/***************************************************************************
* EOF: TEMPLATE.C
****************************************************************************/


