#include "mbed.h"

//prototypes
void FadeToColor(char r,char g, char b);
void FastColorChg(char r,char g, char b);
void PlayScript(char s);
void BlinkInit(void);
//DEFINES
#define BLINKADR    0x12

I2C blink(p9,p10);

int main() {
    BlinkInit();
    FadeToColor(0x00,0x00,0x00);
    wait(2);
    FadeToColor(0xff,0xff,0xff);
    wait(2);
    while(1) {
        PlayScript(12); //virtual candle
        wait(60);   // 10 sec script play
        PlayScript(13); //water reflexion
        wait(60);   // 10 sec script play
        PlayScript(11); //moonlight
        wait(60);   // 10 sec script play
        PlayScript(16); //thunderstorms
        wait(60);   // 10 sec script play
    }
}
void BlinkInit(void)
{
    char data[1] = {'o'};
    blink.frequency(400000);
    blink.write(0x00, data, 1);  // will stop it at whatever address  
}
void FadeToColor(char r,char g, char b)
{
    char data[4] = {'c',r,g,b};
    blink.write(BLINKADR, data, 4);
}
void FastColorChg(char r,char g, char b)
{
    char data[4] = {'n',r,g,b};
    blink.write(BLINKADR, data, 4);
}
void PlayScript(char s)
{
    FadeToColor(0x00,0x00,0x00); // fade to black
    wait(0.25); //100 ms to make sure fade is complete
    if(s < 19) //only 19 scripts onboard
    {
        char data[4] = {'p',s,0,0}; //play script from start indefinetly
        blink.write(BLINKADR, data, 4);
    }
}

