/**
* @author Christian Brisson
*
* @section LICENSE
*
* Copyright (c) 2011 mbed
*
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
* THE SOFTWARE.
*
* @section DESCRIPTION
*
* Wifly RN131-C, wifi module
*
* Datasheet:
*
* http://www.sparkfun.com/datasheets/Wireless/WiFi/WiFlyGSX-um2.pdf
*/
#ifndef WIFLY_H
#define WIFLY_H

#include    "mbed.h"
#define     MODSERIAL_DEFAULT_RX_BUFFER_SIZE 256
#define     MODSERIAL_DEFAULT_TX_BUFFER_SIZE 32 
#include    "MODSERIAL.h"



#define     RX_BUFFER_SIZE  256
#define     END_LINE        0x0A
#define     SPACE           0x20
#define     WAIT_TIME_OUT   5000    //5seconds
#define     DATAMODE        true
#define     CMDMODE         false

const   char    RDY_PHRASE[] = "*READY*\0"; // + 0d 0a
const   char    ACK_PHRASE[] = "AOK\0" ; //always +0d 0a
const   char    ENTER_CMD[] = {'C','M','D',0x0D,0x0A,'\0'};
const   char    EXIT_CMD[] = {0x0D,'E','X','I','T',0x0D,0x0A,'\0'};

class wifly {
    
    public:
    /*
    */
    wifly(  PinName tx, PinName rx, PinName reset);
    /*
        return 0  if no response from wifly within 5 seconds
        This fonctions waits the the *READY* sequence from wifly
        return 1 if sequence received!
    */
    bool    wiflyInit(void);
    /*
    */
    void ResetBuffer(void);
    /*
    */
    bool CmdMode(void);
    /*
    */
    bool EndCmdMode(void);
    /*
    */
    bool WaitForConfirmation(const char * tbl);
    /*
    */
    void Push(char c);
    /*
    */
    char Pop(void);
    /*
    */
    int readable(void);
    
    
    
    private:
    void    SwitchToCmdBuffer(void);
    void    SwitchToDataBuffer(void);
    void    InitBuffer(void);
    
    Timer           t;
    MODSERIAL          wifi;
    DigitalOut      reset_pin;
    bool            Mode;               //true : datamode   false : cmdmode
    bool            DataRxInProgress;
    //circular rx buffer stuff
    char            RxBuffer[RX_BUFFER_SIZE+1];
    int             RxR,RxW;
    int             RxCnt;
    
    void            handler_rx(void);
    bool            WasReset;
    bool            wifly_rdy;
};
#endif