#include "mbed.h"
#include "wifly.h"

wifly::wifly(   PinName tx, PinName rx, PinName _reset   ): wifi(tx, rx), reset_pin(_reset) {
    reset_pin = 0;
    
    
    
}

bool    wifly::wiflyInit(void){
    wifi.baud(9600);
    reset_pin = 1;
    if(!WaitForConfirmation(RDY_PHRASE)) return 0;
    
    //wifi.attach(this, &wifly::handler_rx, MODSERIAL::RxIrq);
    return 1;
}


bool wifly::WaitForConfirmation(const char * tbl){
    char x = 0;
    t.start();
    t.reset();
    do{
        if(wifi.readable()){
            if(wifi.getc() == tbl[x])x++;
        }
        if(t.read_ms() > WAIT_TIME_OUT){
            t.stop();
            return 0;
        }
    }
    while(tbl[x] != '\0'); //whole command received!
    t.stop();
    return 1;
}

/*
*/
bool wifly::CmdMode(void){
    while(DataRxInProgress);    //we have to wait till packet has come in

    //now we are set to send commands    
    wifi.printf("$$$");
    return WaitForConfirmation(ENTER_CMD); 
}
/*
*/
bool wifly::EndCmdMode(void){
    bool result;
    wifi.printf("exit\r");
    result = WaitForConfirmation(EXIT_CMD); 
    return result;
}


void wifly::handler_rx(void) {
    char c = wifi.getc();
}


