#include "mbed.h"
#include "wifly.h"

DigitalOut  myled(LED1);
wifly       d(p28,p27,p29);
Serial      pc(USBTX,USBRX);

int main() {
    if(d.wiflyInit()){
        pc.printf("Wifly Alive!\n\r");
    }
    else{
        return -1;
    }
    if(d.CmdMode()){
        pc.printf("Succesful Entry in command mode!\n\r");
    }
    else{
        pc.printf("Critical Error Fail!\n\r");
        return -1;
    }
    wait(1.0);
    if(d.EndCmdMode()){
        pc.printf("Succesful Exited command mode!\n\r");
    }
    else{
        pc.printf("Critical Error Fail!\n\r");
        return -1;
    }
    while(1) {
        myled = 1;
        wait(0.2);
        myled = 0;
        wait(0.2);
    }
}
