#include "RingBuffer.h"

RingBuffer::RingBuffer(uint32_t NumberOfElements,uint32_t SizeOfElement)
{
    m_ElementSize = SizeOfElement;
    m_size = NumberOfElements;
    m_buf = new uint8_t[m_size*m_ElementSize];
    m_latchingbuffer = new uint8_t[m_ElementSize];
    clear();
}
RingBuffer::~RingBuffer()
{
    delete [] m_buf;
    delete [] m_latchingbuffer;
}
void RingBuffer::clear(void)
{
    m_wloc = 0;
    m_rloc = 0;
    m_ActualCapacity = 0;
    memset(m_buf, 0, m_size * m_ElementSize);   
    memset(m_latchingbuffer, 0,  m_ElementSize); 
    return;
}
void RingBuffer::put(void* data)
{
    uint8_t* srcData = (uint8_t*)data;
    uint8_t* dstData = m_buf + (m_wloc*m_ElementSize);
    
    memcpy(dstData,srcData,m_ElementSize);
    
    m_wloc++;
    m_wloc %= (m_size);
    m_ActualCapacity++;       
}

int RingBuffer::get(void* data)
{
    uint8_t* SrcData =  m_buf + (m_rloc*m_ElementSize);
    uint8_t* dstData = (uint8_t*)data;
    memcpy(dstData,SrcData,m_ElementSize);
    m_rloc++;
    m_rloc %= (m_size);
    m_ActualCapacity--;
    return 1;
}

void RingBuffer::LatchBuffer(void* DstBuffer)
{
    uint8_t* src = (uint8_t*)DstBuffer;
    do
    {
        get(src);
        src++;
    }
    while(m_ActualCapacity > 0);
}
/*
template <class T>
RingBuffer<T>::RingBuffer(uint32_t size)
{
    m_buf = new T[size];
    m_LatchedBuf = new T[size];
    m_size = size;
    clear();
    
    return;
}
 
template <class T>
RingBuffer<T>::~RingBuffer()
{
    delete [] m_buf;
    
    return;
}

template <class T>
void RingBuffer<T>::clear(void)
{
    m_SetBufferToReadOnly = false;
    m_wloc = 0;
    m_rloc = 0;
    m_ActualCapacity = 0;
    memset(m_buf, 0, m_size * sizeof(T));    
    return;
}

template <class T>
uint32_t RingBuffer<T>::getSize()
{
    return m_size;
} //Return the size of the ring buffer

template <class T>    
uint32_t RingBuffer<T>::getCapacity()
{
    return m_ActualCapacity;
} //Return the number of elements stored in the buffer

template <class T>
void RingBuffer<T>::put(T data)
{
    if(!m_SetBufferToReadOnly)
    {
        m_buf[m_wloc++] = data;
        m_wloc %= (m_size);
        if(m_ActualCapacity >= m_size)
        {
            //we are overriding old data! lets increment the read pointer accordingly
            m_rloc++;
            m_rloc %= (m_size);
        }
        else
            m_ActualCapacity++;
        
    }  
    return;
}
 
template <class T>
T RingBuffer<T>::get(void)
{
    T data_pos = 0;
    if(m_ActualCapacity > 0)
    {
        data_pos = m_buf[m_rloc++];
        m_rloc %= (m_size);
        m_ActualCapacity--;
    }
    else
    {
        m_SetBufferToReadOnly = false;  //if we have and empty buffer ReadOnly is disabled automatically
        m_ActualCapacity = 0;
    }
    return data_pos;
}

template <class T>
void RingBuffer<T>::LatchBuffer(T* DstBuffer)
{
    do
    {
        *DstBuffer++ = get();
    }
    while(m_ActualCapacity > 0);
}

// make the linker aware of some possible types
template class RingBuffer<uint8_t>;
template class RingBuffer<int8_t>;
template class RingBuffer<uint16_t>;
template class RingBuffer<int16_t>;
template class RingBuffer<uint32_t>;
template class RingBuffer<int32_t>;
template class RingBuffer<uint64_t>;
template class RingBuffer<int64_t>;
template class RingBuffer<char>;
template class RingBuffer<wchar_t>;
*/
