
#ifndef FIFO_H
#define FIFO_H

#include <stdint.h>
#include <string.h>

class RingBuffer
{
    private:
    uint8_t*            m_buf;
    uint8_t*            m_latchingbuffer;
    volatile uint32_t   m_wloc;
    volatile uint32_t   m_rloc;
    volatile uint32_t   m_ActualCapacity;
    uint32_t            m_size;
    uint32_t            m_ElementSize;
    
    public:
    RingBuffer(uint32_t NumberOfElements = 128,uint32_t SizeOfElement = 1);
    ~RingBuffer();
    
    void put(void* data);
    int get(void* data);
    
    void clear(void);
    uint32_t GetSize(){return m_size;}; //Return the size of the ring buffer
    
    uint32_t GetCapacity(){return m_ActualCapacity;}; //Return the number of elements stored in the buffer
    
    uint32_t GetElementSize(){return m_ElementSize;};
    
    void LatchBuffer(void* DstBuffer);
};
/*
template <typename T>
class RingBuffer
{
    private:
    T   *m_buf;
    T   *m_LatchedBuf;
    volatile uint32_t   m_wloc;
    volatile uint32_t   m_rloc;
    volatile uint32_t   m_ActualCapacity;
    uint32_t            m_size;
    bool                m_SetBufferToReadOnly;      //Put ring buffer into readonly mode, this way we can acces the underlying raw data with less
                                                    //risk of behing overriten (Deprecated ... to be removed)                                            
    public:
    RingBuffer(uint32_t size = 128);
    void clear(void);
    uint32_t getSize(); //Return the size of the ring buffer
    
    uint32_t getCapacity(); //Return the number of elements stored in the buffer
    
    
    void LatchBuffer(T* DstBuffer);
    
    ~RingBuffer();
    
    void put(T data);
    
    T get(void);
    
    
    
};
*/
#endif