#include "PatternFinder.h"
PatternFinder::PatternFinder(void* PatternData, uint32_t PatternLength, uint32_t PatternElementSize)
{
    m_PatternSize = PatternLength;
    m_PatternElementSize = PatternElementSize;
    m_RefPattern = new uint8_t[m_PatternSize*m_PatternElementSize];
    
    uint8_t *src = (uint8_t*)PatternData;
    uint8_t *dst = (uint8_t*)m_RefPattern + (m_PatternSize-1)*m_PatternElementSize;
    //We must invert the given pattern so that it better fits the matching algorithm
    for(int x = 0; x < m_PatternSize ;x++)
    {
        memcpy(dst,src,m_PatternElementSize);
        dst-=m_PatternElementSize;
        src+=m_PatternElementSize;
    }
    m_CurDataStream = new uint8_t[m_PatternSize*m_PatternElementSize];  
    return;
}

PatternFinder::~PatternFinder()
{
    delete [] m_RefPattern;
    delete [] m_CurDataStream;
    return;
}

