#ifndef PATTERN_FINDER_H
#define PATTERN_FINDER_H
#include <stdint.h>
#include <string.h>

class PatternFinder
{
    private:
    uint8_t*    m_RefPattern;
    uint8_t*    m_CurDataStream;
    uint32_t    m_PatternSize;
    uint32_t    m_PatternElementSize;
    void        ShiftDataInStream(void* data);
    bool        IsPatternFound(void);
    
    public:
    PatternFinder(void* PatternData, uint32_t PatternLength, uint32_t PatternElementSize = 1);
    ~PatternFinder();  
    bool CheckPattern(void* data);  //returns true if pattern was found in the stream
};
inline void PatternFinder::ShiftDataInStream(void* data)
{
    uint8_t *src;
    uint8_t *dst;
    for(int element = (m_PatternSize-1);element > 0; element--)
    {
        dst = m_CurDataStream + element*m_PatternElementSize;
        src = m_CurDataStream + (element-1)*m_PatternElementSize;
        memcpy(dst,src,m_PatternElementSize);
    }
    src = (uint8_t*)data;
    dst = &m_CurDataStream[0];
    memcpy(dst,src,m_PatternElementSize);
}

inline bool PatternFinder::IsPatternFound(void)
{
    uint32_t NumberOfIdenticalElementsFoundInPattern = 0;
    for(int x = 0;x < m_PatternSize*m_PatternElementSize;x++)
    {
        if(m_CurDataStream[x] == m_RefPattern[x])
        {
            NumberOfIdenticalElementsFoundInPattern++;
        }
    }
    return (NumberOfIdenticalElementsFoundInPattern == (m_PatternSize*m_PatternElementSize));
}

inline bool PatternFinder::CheckPattern(void* data)
{
    ShiftDataInStream(data);
    return IsPatternFound();
}
#endif