#include "mbed.h"
#include "mbed_genie.h"

DigitalOut myled(LED1);
DigitalOut myledr(LED2);
/*
    The Mbed4dGenie class requires 3 parameters
    1 - Tx pin
    2 - Rx pin
    3 - Reset pin
*/
Mbed4dGenie lcd4d(PTE0,PTE1,PTB9);

void MyGenieEventHandler(void)
{
    genieFrame TheEven;
    while(lcd4d.PendingFrames()){
        if(lcd4d.genieDequeueEvent(&TheEven))
        {
            
            if( TheEven.reportObject.cmd == GENIE_REPORT_EVENT)
            {
                myledr = !myledr; //toggle led when receiving a genie event frame
            }
            
            
        }
    }
}

int main() {
    int temp = 0;
    printf("Mbed Genie demo \n\r");
    lcd4d.Start(); 
    lcd4d.genieAttachEventHandler(&MyGenieEventHandler);
 /*
 for example, in this loop we increment the object from 0 to 100
 */
 
    while(1) {
        if(temp >= 100)
        {
            temp = 0;
        }
        else
        {
            temp++;
        }

        //printf("write:%d\n\r",lcd4d.genieWriteObject(GENIE_OBJ_LED_DIGITS,1,temp));
        int error;
        error = lcd4d.genieWriteObject(GENIE_OBJ_LED_DIGITS,1,temp);
        if(error != ERROR_NONE)
        {
            printf("Error is:%d\n\r",error);
        }
        
        myled = 1;
        //wait(0.05);
        //printf("read:%d\n\r",lcd4d.genieReadObj(GENIE_OBJ_LED_DIGITS,1));
        error = lcd4d.genieReadObj(GENIE_OBJ_LED_DIGITS,1);
        if(error != ERROR_NONE)
        {
            printf("Error is:%d\n\r",error);
        }
        myled = 0;
        //wait(0.05);
    }
}
