#include "mbed.h"
#include "DecodersUtils.h"
#include "mbedGPSDefs.h"

#include "USBSerial.h"
extern USBSerial  pc;          // Virtual serial port over USB

void DecodeGPVTG(char * tokenStr,GPSInfo& data)
{
    //pc.printf("VTGDecoder debug: %s\n\r",tokenStr);
    int parameterCount = 0;
    char *rest; // to point to the rest of the string after token extraction.
    char *token; // to point to the actual token returned.
    char *ptr = tokenStr; // make q point to start of hello.
    //token = strtok_single(ptr, ",");
    token = strtok_single(ptr, ",");
    while (token != NULL)
    {
        //pc.printf("%d:%s ",parameterCount,token);
        if(parameterCount == 1)
            data.TrueTrack = atof(token);
            
        if(parameterCount == 3)
            data.MagneticTrack = atof(token);
            
        if(parameterCount == 5)
            data.GroundSpeedN = atof(token);
            
        if(parameterCount == 7)
            data.GroundSpeedK = atof(token);
            
        parameterCount++;
        ptr = rest; // rest contains the left over part..assign it to ptr.
        //token = strtok_r(ptr, ",",&rest);
        token = strtok_single(NULL, ",");
    }
    //pc.printf("\n\r");
}