#ifndef _MBED_GPS_H_
#define _MBED_GPS_H_
#include "mbedGPSDefs.h"
#include "mbed.h"
#define MESSAGE_QUEUE_SIZE 20


    
    
class GPS : RawSerial{
    public:
    GPS(PinName TxPin,PinName RxPin);
    
    void SetBaud(int rate);
    
    ECEFPoint ReadPositionECEF(void);
    
    ECEFDistance DistanceBetweenTwoWP(ECEFPoint p1,ECEFPoint p2);
    
    geodPoint   ReadDecGeodLoc(void);
    geodPoint   ReadRawGeodLoc(void);
    
    bool        FixIs3d(void);
    bool        FixIs2d(void);
    bool        GPSFixValid(void);
    
    GPSInfo info;   //current gps information
    
    void UpdateGPS(void);       

    private:
    void RxIrqHandler(void);    
    message GPSRMCMessage;
    message GPSVTGMessage;
    message GPSGSAMessage;
    message GPSGGAMessage;
    message RxMessageBuffer;
    uint32_t RxQueueSize;
    uint32_t RxQueueWriteIndex;
    uint32_t RxQueueReadIndex;
    char insertIndex;
    Timer _gpsTimer;
};

#endif