#include "mbed.h"
#include "MPU6050.h"
#include "shared.h"

DigitalOut myled(LED1);
MPU6050 mpu;

int16_t ax, ay, az;
int16_t gx, gy, gz;

int main()
{
    pc.baud(115200);
    pc.printf("MPU6050 test\r\n");
    pc.printf("MPU6050 initialize \r\n");

    mpu.initialize();
    pc.printf("MPU6050 testConnection \r\n");

    bool mpu6050TestResult = mpu.testConnection();
    if(mpu6050TestResult) {
        pc.printf("MPU6050 test passed \r\n");
    } else {
        pc.printf("MPU6050 test failed \r\n");
    }
   
    while(1) {
        wait(1);
        mpu.getMotion6(&ax, &ay, &az, &gx, &gy, &gz);
        //writing current accelerometer and gyro position 
        pc.printf("%d;%d;%d;%d;%d;%d\r\n",ax,ay,az,gx,gy,gz);
    }
}
