#include "mbed.h"
#include "MPU6050.h"

MPU6050 mpu(I2C_SDA, I2C_SCL);
Serial pc(SERIAL_TX, SERIAL_RX);

int main()
{
    pc.baud(115200);
    pc.printf("Alive!\r\n");
    
    if (mpu.testConnection())
    {
        pc.printf("Connection OK!\r\n");
    }
    else
    {
        pc.printf("Connect fail\r\n");
    }
    
    mpu.setSleepMode(false);
    mpu.setAcceleroRange(MPU6050_ACCELERO_RANGE_2G);
    
    while (1)
    {
        pc.printf("%d\r\n", mpu.getAcceleroRawX());
        wait(.5);
        
    }
    
    
}