#include "motordriver.h"

#include "mbed.h"

Motor::Motor(PinName pwm, PinName fwd, PinName rev, int brakeable):
        _pwm(pwm), _fwd(fwd), _rev(rev) {

    // Set initial condition of PWM
    _pwm.period(0.001);
    _pwm = 0;

    // Initial condition of output enables
    _fwd = 0;
    _rev = 0;

    //set if the motor dirver is capable of braking. (addition)
    Brakeable= brakeable;
    sign = 0;//i.e nothing.
}

float Motor::speed(float speed) {
    float temp = 0;
    if (sign == 0) {
        _fwd = (speed > 0.0);
        _rev = (speed < 0.0);
        temp = abs(speed);
        _pwm = temp;
    } else if (sign == 1) {
        if (speed < 0) {
            _fwd = (speed > 0.0);
            _rev = (speed < 0.0);
            _pwm = 0;
            temp = 0;
       } else {
            _fwd = (speed > 0.0);
            _rev = (speed < 0.0);
            temp = abs(speed);
            _pwm = temp;
        }
    } else if (sign == -1) {
        if (speed > 0) {
            _fwd = (speed > 0.0);
            _rev = (speed < 0.0);
            _pwm = 0;
            temp = 0;
        } else {
            _fwd = (speed > 0.0);
            _rev = (speed < 0.0);
            temp = abs(speed);
            _pwm = temp;
        }
    }
    if (speed > 0)
        sign = 1;
    else if (speed < 0) {
        sign = -1;
    } else if (speed == 0) {
        sign = 0;
    }
    return temp;
}
//  (additions)
void Motor::coast(void) {
    _fwd = 0;
    _rev = 0;
    _pwm = 0;
    sign = 0;
}

float Motor::stop(float duty) {
    if (Brakeable == 1) {
        _fwd = 1;
        _rev = 1;
        _pwm = duty;
        sign = 0;
        return duty;
    } else
        Motor::coast();
        return -1;
}

float Motor::state(void) {
    if ((_fwd == _rev) && (_pwm > 0)) {
        return -2;//braking
    } else if (_pwm == 0) {
        return 2;//coasting
    } else if ((_fwd == 0) && (_rev == 1)) {
        return -(_pwm);//reversing
    }  else if ((_fwd == 1) && (_rev == 0)) {
        return _pwm;//fowards
    } else
        return -3;//error
}