#include "mbed.h"
#include "C12832_lcd.h"

// Map the LPC1768 pins to the arduino pin names
// These are the only things that are constant between ARCH, FRDM, u-blox etc
#define ARD_D5  P2_1
#define ARD_D7  P2_11
#define ARD_D10 P1_21
#define ARD_D11 P1_24
#define ARD_D12 P1_23
#define ARD_D13 P1_20

DigitalOut redled(ARD_D5);

// ==== Using SDK primitives ======
// Construct the required pin functions, this works!

/*
DigitalOut a_d7  (ARD_D7);  // a0
DigitalOut a_d10 (ARD_D10); // nCS
DigitalOut a_d12 (ARD_D12); // reset
SPI myspi (ARD_D11,NC,ARD_D13); // MOSI
*/


// ==== Using the LCD library ======

// Use my fork of the original library that allows pin names to be passed in
// This works on KL25Z and Seeedstudio Arch
// C12832_LCD(PinName mosi, PinName sck, PinName reset, PinName a0, PinName ncs, const char* name = "LCD");
// using this causes the program to hang
C12832_LCD lcd(ARD_D11, ARD_D13, ARD_D12, ARD_D7, ARD_D10);



int main()
{

    int i=0;
    while(1) {

// === USING THE LCD ====
// Note that the program will hang, even if we do not call any of the LCD functions
// Is it the cosntructor breaking things
//        lcd.cls();
//        lcd.locate(0,3);
//        lcd.printf("Hello %d",i);
                
                
// === USING THE SDK Primitives ===
// If we just use the SPI and DigitalOut, instead we can access them happily
// and the program runs
//        a_d7 = !a_d7;
//        a_d10 = !a_d10;
//        a_d12 = !a_d12;
//        myspi.write(i);


        wait(0.2);
        redled = !redled; // I have an red LED on my test board.. for sanity :)
        i++;
    }

}
