#include "mbed.h"

DigitalOut myled(LED1);

extern int stdio_retargeting_module;

/**
 * Initialize the system
 *
 * @param  none
 * @return none
 *
 * @brief  Setup the microcontroller system.
 *         Initialize the System.
*/
extern "C" void $Sub$$SystemInit (void)
{

// select the PLL input
    LPC_SYSCON->SYSPLLCLKSEL  = 0x0;                // Select PLL Input source 0=IRC, 1=OSC
    LPC_SYSCON->SYSPLLCLKUEN  = 0x01;               /* Update Clock Source      */
    LPC_SYSCON->SYSPLLCLKUEN  = 0x00;               /* Toggle Update Register   */
    LPC_SYSCON->SYSPLLCLKUEN  = 0x01;
    while (!(LPC_SYSCON->SYSPLLCLKUEN & 0x01));     /* Wait Until Updated       */

// Power up the system PLL
    LPC_SYSCON->SYSPLLCTRL    = 0x00000023;
    LPC_SYSCON->PDRUNCFG     &= ~(1 << 7);          /* Power-up SYSPLL          */
    while (!(LPC_SYSCON->SYSPLLSTAT & 0x01));       /* Wait Until PLL Locked    */

// Select the main clock source
    LPC_SYSCON->MAINCLKSEL    = 0x3;                // Select main Clock source, 0=IRC, 1=PLLin, 2=WDO, 3=PLLout
    LPC_SYSCON->MAINCLKUEN    = 0x01;               /* Update MCLK Clock Source */
    LPC_SYSCON->MAINCLKUEN    = 0x00;               /* Toggle Update Register   */
    LPC_SYSCON->MAINCLKUEN    = 0x01;
    while (!(LPC_SYSCON->MAINCLKUEN & 0x01));       /* Wait Until Updated       */

    LPC_SYSCON->SYSAHBCLKDIV  = 0x00000001;

    LPC_SYSCON->PDRUNCFG     &= ~(1 << 10);         /* Power-up USB PHY         */
    LPC_SYSCON->PDRUNCFG     &= ~(1 <<  8);         /* Power-up USB PLL         */
    LPC_SYSCON->USBPLLCLKSEL  = 0x0;                // 0=IRC, 1=System clock, only good for low speed
    LPC_SYSCON->USBPLLCLKUEN  = 0x01;               /* Update Clock Source      */
    LPC_SYSCON->USBPLLCLKUEN  = 0x00;               /* Toggle Update Register   */
    LPC_SYSCON->USBPLLCLKUEN  = 0x01;

    while (!(LPC_SYSCON->USBPLLCLKUEN & 0x01));     /* Wait Until Updated       */
    LPC_SYSCON->USBPLLCTRL    = 0x00000023;

    while (!(LPC_SYSCON->USBPLLSTAT   & 0x01));     /* Wait Until PLL Locked    */
    LPC_SYSCON->USBCLKSEL     = 0x00;               /* Select USB PLL           */

    LPC_SYSCON->USBCLKSEL     = 0x00000000;      /* Select USB Clock         */
    LPC_SYSCON->USBCLKDIV     = 0x00000001;      /* Set USB clock divider    */

    /* System clock to the IOCON needs to be enabled or
    most of the I/O related peripherals won't work. */
    LPC_SYSCON->SYSAHBCLKCTRL |= (1<<16);
    stdio_retargeting_module = 1;

}


int main()
{
    while(1) {
        myled = 1;
        wait(0.25);
        myled = 0;
        wait(0.25);
    }
}
