#include "mbed.h"
#include "Motor.h"

/*
 *  This code reads command files to control the motors.
 *  The file name it reads is command.txt
 *
 *  The file format is :
 *
 *      <command> <data> 
 *
 *  The commands are :
 *
 *      F - Forward, both motor on full speed forwards
 *      B - Backwards, both motors on full speed in reverse
 *      L - Left, left motor full speed backwards, right motor full speed forward
 *      R - Right, right motor full speed backwards, left motor full speed forward
 *      W - Wait, both motors stop
 *
 *  Data :
 *
 *      Data is a time in milliseconds to carry out the command.
 *
 *  Example :
 *
 *      F 1000
 *      W 200
 *      L 1000
 *      W 200
 *      R 1000
 *      W 200
 *      B 1000
 *      W 200
 */


LocalFileSystem local("local");

Serial pc(USBTX, USBRX);

BusOut leds(LED1,LED2,LED3,LED4);

Motor left(p23, p6, p5);
Motor right(p24, p8, p7);


int main() {    
            
    leds = 0x0;
    
    // flash the LED 3 time before starting
    for (int i=0; i < 3 ; i++) {
        leds = 0x1;    
        wait (0.5);    
        leds = 0x0;    
        wait (0.5);
    }
        
    // Open the command.txt file
    FILE *commandfile = fopen("/local/command.txt", "r");

    // If there is no file, sit flashing the LEDs
    if (commandfile == NULL) { 
        while(1) {
            leds = 0xf;
            wait(0.5);
            leds = 0x0;
            wait(0.5);
        }
    } 
    
    // process each of the commands in the file
    while (!feof(commandfile)) {
    
        char command = 0;
        int data = 0.0;
         
        // Read from the command file
        fscanf(commandfile, "%c %d\n", &command, &data); 
                         
        if((command=='f') || (command=='F')){
                left.speed(1);
                right.speed(1);
        }        
        else if((command=='b') || (command=='B')){
                left.speed(-1);
                right.speed(-1);
        }
        else if((command=='l') || (command=='L')){
                left.speed(-1);
                right.speed(1);
        }
        else if ((command=='r') || (command=='R')){
                left.speed(1);
                right.speed(-1);
        }
        // Wait commands
        else if ((command=='w') || (command=='W')){
        }

        // wait for the length of the command
        wait(data/1000.0);        

        // Switch the motors off
        left.speed(0);
        right.speed(0);


    } // this is the end of the file while loop


    for (int i=0;i<10;i++) {
        leds = 0x0;
        wait (0.2);
        leds = 0xf;
        wait (0.2);
    }
        
    fclose(commandfile);
    exit(0);
    
} // end of main
