#include "mbed.h"
#include "C027.h"

#include "C12832_lcd.h"
C12832_LCD lcd(D11, D13, D12, D7, D10);

#include "LM75B.h"
LM75B sensor(D14, D15);

#include "MMA7660.h"
MMA7660 MMA(D14, D15);

PwmOut spkr(D6);

AnalogIn pot1 (A0);
AnalogIn pot2 (A1);

DigitalIn up(A2);
DigitalIn down(A3);
DigitalIn left(A4);
AnalogIn right(A5);
DigitalIn center(D4);

DigitalOut redled(D5);
DigitalOut blueled(D8);
DigitalOut greenled(D9);

Serial pc(USBTX, USBRX);

void clearConsole()
{
    lcd.cls();
    lcd.locate(0,3);
    while(pc.readable()) {
        int c = pc.getc();
    }
}   

int main()
{

    redled = 1;
    blueled =1;
    greenled=1;
    int i=0;
    
    puts("LCD Test");

    while (!pc.readable()) {
        lcd.cls();
        lcd.locate(0,3);
        lcd.printf("woot! %d!",i);
        i++;
        redled = !redled;
        wait(1.0);
    }

    clearConsole();
    puts("Joystick Test");

    while (!pc.readable()) {
        redled =  !up && ! down;
        blueled = !center;
        greenled= !left && !right;
    }
    
    clearConsole();
    puts("Pot Test");

    while (!pc.readable()) {
        redled = 1;
        wait(pot1.read());
        redled = 0;
        wait(pot2.read());
    }
    
    clearConsole();
    puts("Pot Test 2");

    while (!pc.readable()) {
        lcd.cls();
        lcd.locate(0,3);
        lcd.printf("%.3f  %.3f %.3f", pot1.read(),pot2.read(), right.read());
        wait(0.2);
    }
    
    clearConsole();
    puts("Accel / Temp Test");

    while (!pc.readable()) {
        lcd.cls();
        lcd.locate(0,3);
        lcd.printf("Temp = %.3f", (float)sensor);
        lcd.locate(0,14);
        lcd.printf("x=%.2f y=%.2f z=%.2f",MMA.x(), MMA.y(), MMA.z());
        blueled = !blueled;
        greenled = !greenled;
        wait(1.0);
        i++;
    }
    
    clearConsole();
    puts("Speaker Test");
    
    for(int j=0; j<3; j++) {
        for (float i=2000.0; i<4000.0; i+=100) {
            spkr.period(1.0/i);
            spkr=0.5;
            wait(0.1);
        }
        spkr=0.0;
        wait(2.0f);
    }
    
    puts("Test Complete");
}


