#include "mbed.h"
#include "arduino.h"
#include "C12832.h"

#include "LM75B.h"
#include "MMA7660.h"



C12832_LCD lcd(ARD_D11,ARD_D13, ARD_D12, ARD_D7, ARD_D10);

DigitalOut redled(ARD_D5);
DigitalOut blueled(ARD_D8);
DigitalOut greenled(ARD_D9);

LM75B sensor(ARD_SDA,ARD_SCL);
MMA7660 MMA(ARD_SDA,ARD_SCL);

DigitalOut spk(ARD_D6);

AnalogIn pot1 (ARD_A0);
AnalogIn pot2 (ARD_A1);

DigitalIn up(ARD_A2);
DigitalIn down(ARD_A3);
DigitalIn left(ARD_A4);
AnalogIn right(ARD_A5);
DigitalIn center(ARD_D4);





int main()
{

    int i=0;
    

        while(1) {
            lcd.cls();
            lcd.locate(0,3);
            lcd.printf("Temp = %.3f", (float)sensor);
            lcd.locate(0,14);
            lcd.printf("x=%.2f y=%.2f z=%.2f",MMA.x(), MMA.y(), MMA.z());
            wait(1.0);
            i++;

        }    
    
    
    
    
    
    
    /*
    
    
    
    
    while(1) {

// === USING THE LCD ====
// Note that the program will hang, even if we do not call any of the LCD functions
// Is it the cosntructor breaking things
        lcd.cls();
        lcd.locate(0,3);
        lcd.printf("Hello %d",i);
                
                
// === USING THE SDK Primitives ===
// If we just use the SPI and DigitalOut, instead we can access them happily
// and the program runs
//        a_d7 = !a_d7;
//        a_d10 = !a_d10;
//        a_d12 = !a_d12;
//        myspi.write(i);


        wait(0.2);
        redled = !redled; // I have an red LED on my test board.. for sanity :)
        i++;
    }
*/




}
