#include "mbed.h"
#include "MSCFileSystem.h"
#include "m3pi.h"

#define MOTOR_ENABLED
#define USBFS

m3pi m3pi;

BusOut leds(LED1,LED2,LED3,LED4);

DigitalIn button(p21);

int main() {

    // pull up the digital input for the button - The
    button.mode(PullUp);

    LocalFileSystem *lfs = NULL;
    MSCFileSystem *mfs = NULL;
    m3pi.locate(0,1);

    if (button) {
        mfs = new MSCFileSystem("fs");
        m3pi.printf(" USB    ");
    } else {
        lfs = new LocalFileSystem("fs");
        m3pi.printf(" Local    ");
    }
 
    wait (0.5);

    float speed = 0.5;
    leds = 0x0;

    // Open the command.txt file
    FILE *commandfile = fopen("/fs/command.txt", "r");

    // If there is no file, sit flashing the LEDs
    if (commandfile == NULL) {
        m3pi.cls();
        m3pi.printf("No File");
        while (1) {
            leds=0x9;
            wait(0.2);
            leds=0x6;
            wait(0.2);
        }
    }

    printf("File found\n");

    m3pi.cls();
    m3pi.printf(" File   ");
    m3pi.locate(0,1);
    m3pi.printf(" Found  ");

    wait (0.5);

    // process each of the commands in the file
    while (!feof(commandfile)) {

        char command = 0;
        int data = 0.0;

        // Read from the command file
        fscanf(commandfile, "%c %d\n", &command, &data);
        printf("%c %d\n",command,data);

        m3pi.cls();
        m3pi.printf(" %c %4d",command,data);

        // Turn forward
        if ((command=='f') || (command=='F')) {
#ifdef MOTOR_ENABLED
            m3pi.forward(speed);
#endif
        }

        // Turn back
        else if ((command=='b') || (command=='B')) {
#ifdef MOTOR_ENABLED
            m3pi.backward(speed);
#endif
        }

        // Turn left
        else if ((command=='l') || (command=='L')) {
#ifdef MOTOR_ENABLED
            m3pi.left(speed);
#endif
        }

        // Turn right
        else if ((command=='r') || (command=='R')) {
#ifdef MOTOR_ENABLED
            m3pi.right(speed);
#endif
        }

        // Set LED 8,4,2,1
        else if ((command=='d') || (command=='D')) {
            leds=data;
        }

        // Set Speed 0-100
        else if ((command=='s') || (command=='S')) {
            if ((data > 0) && (data <= 100)) {
                float foo = data/100.0;
                speed = foo;
                printf("speed = %f\n", foo);
            }
        }

        // Wait commands
        else if ((command=='w') || (command=='W')) {
        }

        // wait for the length of the command
        wait(data/1000.0);
        m3pi.stop();

    } // this is the end of the file while loop

    fclose(commandfile);

    m3pi.stop();
    m3pi.cls();
    m3pi.printf("  Done  ");

    printf("Done\n");

    while (1) {
        leds=0;
        wait(0.5);
        leds=0xf;
        wait(0.5);
    }

} // end of main
