/* mbed Microcontroller Library - USBKeyboard
 * Copyright (c) 2007-2008, sford, pwright
 */
 
#include "Stream.h"
#include "usbhid.h"

#ifndef USBKEYBOARD_H
#define USBKEYBOARD_H

/* Class: USBKeyboard
 *  Emulate a USB Keyboard
 *
 * This class will enumerate as a USB Keyboard to a host computer. 
 * The host should be connected using the USB Device interface pins (D+, D-, GND)
 */
class USBKeyboard : public Stream {
public:

#if 0 // Inhereted from Stream, for documentation only

    /* Function: putc
     *  Send a character keypress
     *
     * Variables:
     *  c - The character to send
     */
    int putc(int c);

    /* Function: printf
     *  Send a formated string of character keypresses
     *
     * Variables:
     *  format - A printf-style format string, followed by the 
     *      variables to use in formating the string.
     */
    int printf(const char* format, ...);

#endif

    virtual int _putc(int value);    
    virtual int _getc();
private:
    usbhid _usbhid;
};


#endif
