#include "mbed.h"
#include "m3pi.h"

m3pi m3pi;
DigitalOut relay (p20);

void charge (float volts);
void charge (float volts)
{

    volatile float current_volts = m3pi.battery();

    if (current_volts < volts) { // needs charging
        relay = 1; // switch relay on        
        while (current_volts < volts) {
            current_volts = m3pi.battery();
            m3pi.cls();
            m3pi.locate(0,0);
            m3pi.printf("%.2f",current_volts);
            wait(10.0);
        }
        relay = 0; // switch relay off
        return;

    } else { // no charege needed
        return;
    }

}


int main()
{

    m3pi.locate(0,1);
    m3pi.printf("LO World");
    
    charge(4.8); // chrage to 4.8v
    
}


