/**
 * Program an AVR with an mbed.
 */

// ATMega328 Datasheet:
//
//  http://www.atmel.com/dyn/resources/prod_documents/doc8271.pdf

#include "AVR910.h"

#define DELETE_BINARY 1

DigitalOut led1(LED1);
DigitalOut led2(LED2);

LocalFileSystem local("local");
Serial pc(USBTX, USBRX);

AVR910 mbedISP(p5, p6, p7, p8); //mosi, miso, sclk, nreset.

int main() {


    int success = -1;

    printf("\nAVR Programmer\nLooking for /local/program.avr\n");

    FILE *fp = fopen("/local/program.avr", "rb");

    if (fp == NULL) {
        pc.printf("Failed to open binary\n");
    } else {
        pc.printf("Binary file opened successfully\n");
        led1 = 1; // in progress
        success = mbedISP.program(fp);
        fclose(fp);
        #ifdef DELETE_BINARY 
            remove("/local/program.avr"); // remove the file when we're done
        #endif    
        led2 = 1; // finished
    }

    if (success < 0) {
        printf("Programming failed.\n");
    } else {
        printf("Programming was successful!\n");
    }

    fclose(fp);


    while (1) {
    }

}