/* USBMouse.h */
/* USB device example: relative mouse */
/* Copyright (c) 2011 ARM Limited. All rights reserved. */

#ifndef _USB_RAW_HID_
#define _USB_RAW_HID_

#include "USBHID.h"

/** USB device: a relative mouse
 *
 * Warning: you can only instantiate one instance of a USB device: USBMouse, USBKeyboard, USBAbsMouse, USBMouseKeyboard, or USBAbsMouseKeyboard.
 *
 * Example:
 * @code
 * #include "mbed.h"
 * #include "USBMouse.h"
 *
 * USBMouse mouse;
 *
 * #define STEP (2)
 * #define SIZE (100)
 *
 * int main(void)
 * {
 *   int32_t a;
 *
 *   while (1)
 *   {
 *       for (a=0; a<SIZE; a++)
 *       {
 *            mouse.move(STEP,0);
 *       }
 *
 *       for (a=0; a<SIZE; a++)
 *       {
 *            mouse.move(0,STEP);
 *       }
 *
 *       for (a=0; a<SIZE; a++)
 *       {
 *            mouse.move(-STEP,0);
 *       }
 *
 *       for (a=0; a<SIZE; a++)
 *       {
 *            mouse.move(0,-STEP);
 *       }
 *   }
 * }
 *
 * @endcode
 */
class USBRawHID: public USBHID
{
    public:
        
        /**
        *   Constructor for a USBMouse (relative mouse)
        */
        USBRawHID(){};
        
        
        virtual uint8_t * ReportDesc();
        
};

#endif