/* USBMouseKeyboard.h */
/* USB device example: Keyboard with a relative mouse */
/* Copyright (c) 2011 ARM Limited. All rights reserved. */

#ifndef _USB_KEYBOARD_REL_MOUSE_
#define _USB_KEYBOARD_REL_MOUSE_

#include "GenericMouse.h"
#include "GenericKeyboard.h"
#include "USBHID.h"

/** USB device: a keyboard and a relative mouse
 *
 * Warning: you can only instantiate one instance of a USB device: USBMouse, USBKeyboard, USBAbsMouse, USBMouseKeyboard, or USBAbsMouseKeyboard.
 *
 * Example:
 * @code
 *
 * #include "mbed.h"
 * #include "USBMouseKeyboard.h"
 *
 * USBMouseKeyboard key_mouse;
 *
 * int main(void)
 * {
 *   while(1)
 *   {
 *       key_mouse.move(20, 0);
 *       key_mouse.puts("Hello World\r\n");
 *       wait(2);
 *   }
 * }
 * @endcode
 */
class USBMouseKeyboard: public GenericMouse, public GenericKeyboard, public USBHID
{
    public:
    
        /**
        *   Constructor for a relative mouse and a keyboard
        *
        */
        USBMouseKeyboard(){};
        
        /**
        * Write a state of the mouse
        *
        * @param x x relative position
        * @param y y relative position
        * @param buttons buttons state (first bit represents MOUSE_LEFT, second bit MOUSE_RIGHT and third bit MOUSE_MIDDLE)
        * @param z wheel state (>0 to scroll down, <0 to scroll up)
        * @return true if there is no error, false otherwise
        */
        virtual bool update(int16_t x, int16_t y, uint8_t buttons, int8_t z);
        
        virtual uint8_t * ReportDesc();
        
        
    private:
        bool mouseWrite(int8_t x, int8_t y, uint8_t buttons, int8_t z);
};

#endif
