/* GenericKeyboard.c */
/* Copyright (c) 2011 ARM Limited. All rights reserved. */

#include "stdint.h"

#include "USBKeyboard.h"
#include "GenericKeyboard.h"


int GenericKeyboard::_putc(int c) {
    return keyCode(keymap[c].modifier, c);
}

bool GenericKeyboard::keyCode(uint8_t modifier, uint8_t key) {
    /* Send a simulated keyboard keypress. Returns true if successful. */

    HID_REPORT report;

    report.data[0] = REPORT_ID_KEYBOARD;
    report.data[1] = modifier;
    report.data[2] = 0;
    report.data[3] = keymap[key].usage;
    report.data[4] = 0;
    report.data[5] = 0;
    report.data[6] = 0;
    report.data[7] = 0;
    report.data[8] = 0;

    report.length = 9;

    if (!USBClass_HID_sendInputReport(EPINT_IN, &report)) {
        return false;
    }
    
    report.data[1] = 0;
    report.data[3] = 0;

    if (!USBClass_HID_sendInputReport(EPINT_IN, &report)) {
        return false;
    }

    return true;

}


bool GenericKeyboard::mediaControl(MEDIA_KEY key) {
    HID_REPORT report;

    report.data[0] = REPORT_ID_VOLUME;
    report.data[1] = (1 << key) & 0x7f;

    report.length = 2;

    return USBClass_HID_sendInputReport(EPINT_IN, &report);
}